/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.graph.scatterplot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import metaanalysis.graph.scatterplot.ScatterPlotGraph;
import metaanalysis.graph.scatterplot.ScatterPlotGraphInput;

public class ScatterPlotFrame
extends JFrame
implements ItemListener {
    private boolean flagBlack = false;
    private final ScatterPlotGraphInput graphInput;
    private final Locale locale;
    private String predictor;
    private ScatterPlotGraph plot;
    private int margineWindows = 40;
    String informazione = System.getProperty("os.name");
    private String osName = "Win";

    public ScatterPlotFrame(ScatterPlotGraphInput graphInput, int larghezza, int altezza, Locale locale) throws HeadlessException {
        super("Plot");
        if (this.informazione.contains(this.osName)) {
            this.setSize(larghezza + this.margineWindows, altezza + this.margineWindows);
        } else {
            this.setSize(larghezza, altezza);
        }
        this.graphInput = graphInput;
        this.locale = locale;
        this.plot = new ScatterPlotGraph(this.graphInput, larghezza, altezza, this.locale);
        this.add(this.plot);
        this.setBackground(Color.white);
        this.plot.validate();
        this.add(this.plot);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
                ScatterPlotFrame.this.resizePlot();
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuExport = new JMenu("Export");
        menuBar.add(menuExport);
        JMenuItem esportaImmagine = new JMenuItem("Save as image");
        esportaImmagine.addItemListener(this);
        menuExport.add(esportaImmagine);
        esportaImmagine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScatterPlotFrame.this.salvaImmagine();
            }
        });
        this.validate();
    }

    public void salvaImmagine() {
        BufferedImage bi = new BufferedImage(this.plot.getWidth(), this.plot.getHeight(), 1);
        Graphics2D g = bi.createGraphics();
        this.plot.paint(g);
        g.dispose();
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter jpgFilter = new FileNameExtensionFilter("File JPG/JPEG", "jpg");
        FileNameExtensionFilter pngFilter = new FileNameExtensionFilter("File PNG", "png");
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(jpgFilter);
        fc.addChoosableFileFilter(pngFilter);
        int returnVal = fc.showSaveDialog(fc);
        if (returnVal == 0) {
            String estensione;
            String msg;
            int r;
            File f = fc.getSelectedFile();
            FileFilter selectedFilter = fc.getFileFilter();
            if (f.exists() && (r = JOptionPane.showConfirmDialog(null, msg = MessageFormat.format("The file ''{0}'' already exist.\nDo you want to override?", f), "Confirm", 0)) == 1) {
                return;
            }
            if (selectedFilter == jpgFilter) {
                estensione = ".jpg";
                if (f.getName().endsWith(estensione)) {
                    estensione = "";
                }
                try {
                    ImageIO.write((RenderedImage)bi, "jpg", new File(f.getPath() + estensione));
                }
                catch (Exception exception) {}
            } else if (selectedFilter == pngFilter) {
                estensione = ".png";
                if (f.getName().endsWith(estensione)) {
                    estensione = "";
                }
                try {
                    ImageIO.write((RenderedImage)bi, "png", new File(f.getPath() + estensione));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void resizePlot() {
        this.plot.setVisible(false);
        this.remove(this.plot);
        this.plot = this.informazione.contains(this.osName) ? new ScatterPlotGraph(this.graphInput, this.getWidth() - this.margineWindows, this.getHeight() - this.margineWindows, this.locale) : new ScatterPlotGraph(this.graphInput, this.getWidth(), this.getHeight(), this.locale);
        this.add(this.plot);
        this.getContentPane().repaint();
        this.repaint();
        this.validate();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        ItemSelectable source = ie.getItemSelectable();
        if (source instanceof JCheckBoxMenuItem) {
            this.plot.riempi();
            this.plot.validate();
            this.validate();
        }
    }

    @Override
    public void validate() {
        super.validate();
        this.plot.validate();
    }
}

