/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.graph.scatterplot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import metaanalysis.graph.scatterplot.ScatterPlotGraphInput;
import metaanalysis.graph.scatterplot.ScatterPlotHandler;

public class ScatterPlotGraph
extends JPanel {
    private final ScatterPlotGraphInput graphInput;
    private final int altezza;
    private final int larghezza;
    private Locale locale;
    private final int raggioCerchio = 5;
    private final int altezzaRombo = 7;
    Font fontNormal;
    Font fontTitoli;
    String pattern2 = "#####0.00";
    String pattern3 = "#####0.000";
    ScatterPlotHandler scatterHandler;

    public ScatterPlotGraph(ScatterPlotGraphInput graphInput, int larghezza, int altezza, Locale locale) {
        this.setBackground(Color.white);
        this.larghezza = larghezza;
        this.altezza = altezza;
        this.setSize(this.larghezza, this.altezza);
        this.fontNormal = new Font("Arial", 0, this.dimensionaFont());
        this.fontTitoli = new Font("Arial", 0, this.dimensionaFont() - 1);
        this.locale = locale;
        this.initComponents();
        this.graphInput = graphInput;
    }

    private int dimensionaFont() {
        int dimensioneX = 14;
        int dimensioneY = 14;
        if (this.larghezza < 100) {
            dimensioneX = 7;
        }
        if (this.larghezza >= 100 && this.larghezza < 200) {
            dimensioneX = 8;
        }
        if (this.larghezza >= 200 && this.larghezza < 300) {
            dimensioneX = 9;
        }
        if (this.larghezza >= 300 && this.larghezza < 400) {
            dimensioneX = 10;
        }
        if (this.larghezza >= 400 && this.larghezza < 500) {
            dimensioneX = 11;
        }
        if (this.larghezza >= 500 && this.larghezza < 600) {
            dimensioneX = 12;
        }
        if (this.larghezza >= 600 && this.larghezza < 800) {
            dimensioneX = 13;
        }
        if (this.larghezza > 800) {
            dimensioneX = 14;
        }
        if (this.altezza < 100) {
            dimensioneY = 9;
        }
        if (this.altezza >= 100 && this.altezza < 200) {
            dimensioneY = 10;
        }
        if (this.altezza >= 200 && this.altezza < 300) {
            dimensioneY = 11;
        }
        if (this.altezza >= 300 && this.altezza < 400) {
            dimensioneY = 12;
        }
        if (this.altezza >= 400 && this.altezza < 500) {
            dimensioneY = 13;
        }
        if (this.altezza >= 500 && this.altezza < 600) {
            dimensioneY = 14;
        }
        if (this.altezza > 600) {
            dimensioneY = 15;
        }
        if (dimensioneX <= dimensioneY) {
            return dimensioneX;
        }
        return dimensioneY;
    }

    private void disegnaTitoli(ScatterPlotHandler scatterPlot) {
        JLabel xLabel = new JLabel(this.graphInput.getPredictor());
        JLabel yLabel = new JLabel("EFFECT SIZE");
        xLabel.setFont(this.fontTitoli);
        yLabel.setFont(this.fontTitoli);
        xLabel.setHorizontalAlignment(0);
        xLabel.setBounds(scatterPlot.marginLeft + scatterPlot.titleLeft, scatterPlot.marginTop + scatterPlot.titleTop + scatterPlot.altezzaUtile + 40, scatterPlot.larghezzaUtile, 20);
        yLabel.setVerticalAlignment(0);
        yLabel.setBounds(scatterPlot.marginLeft + scatterPlot.titleLeft - 70, scatterPlot.marginTop + scatterPlot.titleTop, 20, scatterPlot.altezzaUtile);
        if (this.altezza < 300) {
            yLabel.setText("<HTML>E<br>S</HTML>");
        } else {
            yLabel.setText("<HTML>E<br>F<br>F<br>E<br>C<br>T<br><br>S<br>I<br>Z<br>E</HTML>");
        }
        this.add(xLabel);
        this.add(yLabel);
    }

    private void disegnaRettangolo(ScatterPlotHandler scatterPlot, Graphics g) {
        g.drawRect(scatterPlot.marginLeft + scatterPlot.titleLeft, scatterPlot.marginTop + scatterPlot.titleTop, scatterPlot.larghezzaUtile, scatterPlot.altezzaUtile);
    }

    private void disegnaStudi(ScatterPlotHandler scatterPlot, Graphics grphcs) {
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        DecimalFormat formatoT = (DecimalFormat)nf;
        formatoT.applyPattern(this.pattern2);
        for (int i = 0; i < this.graphInput.getRows().size(); ++i) {
            int raggio = scatterPlot.dimensionaCerchi(i);
            BufferedImage bi = this.getImmagineScalata(0, 0, 2 * raggio, 2 * raggio);
            ImageIcon newIcon = new ImageIcon(bi);
            JLabel label1 = new JLabel(newIcon);
            label1.setBounds(scatterPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getPredictor()) - raggio, scatterPlot.calcolaCoordinataY(this.graphInput.getRows().get(i).getEffectSize()) - raggio, 2 * raggio, 2 * raggio);
            label1.setToolTipText("" + this.graphInput.getRows().get(i).getName() + "   ES " + formatoT.format(this.graphInput.getRows().get(i).getEffectSize()) + "   " + this.graphInput.getPredictor() + " " + formatoT.format(this.graphInput.getRows().get(i).getPredictor()) + "   W " + formatoT.format(this.graphInput.getRows().get(i).getWeight()) + "%");
            this.add(label1);
        }
    }

    public BufferedImage getImmagineScalata(int xTopLeft, int yTopLeft, int larg, int alt) {
        if (larg < 1) {
            larg = 1;
        }
        if (alt < 1) {
            alt = 1;
        }
        BufferedImage thumbImage = new BufferedImage(larg, alt, 2);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = 0.5f;
        float alpha2 = 1.0f;
        graphics2D.setColor(new Color(240, 240, 240));
        graphics2D.setComposite(AlphaComposite.getInstance(3, alpha));
        graphics2D.fillOval(xTopLeft, yTopLeft, larg, alt);
        graphics2D.setColor(Color.black);
        graphics2D.setComposite(AlphaComposite.getInstance(3, alpha2));
        graphics2D.drawOval(xTopLeft, yTopLeft, larg - 2, alt - 2);
        return thumbImage;
    }

    public void disegnaRettaRegressione(ScatterPlotHandler scatterPlot, Graphics g) {
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        DecimalFormat formatoO = (DecimalFormat)nf;
        formatoO.applyPattern(this.pattern2);
        double m = this.graphInput.getM();
        double q = this.graphInput.getQ();
        double x0 = scatterPlot.getMinPredictor() - scatterPlot.getxRangeMargin();
        double y0 = m * x0 + q;
        double xf = scatterPlot.getMaxPredictor() + scatterPlot.getxRangeMargin();
        double yf = m * xf + q;
        g.drawLine(scatterPlot.calcolaCoordinataX(x0), scatterPlot.calcolaCoordinataY(y0), scatterPlot.calcolaCoordinataX(xf), scatterPlot.calcolaCoordinataY(yf));
    }

    private void disegnaScalaRif(ScatterPlotHandler scatterPlot, Graphics g) {
        int larghezzaLabel;
        JLabel refLabel;
        int larghezzaLabel2;
        JLabel refLabel2;
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        DecimalFormat formatoY = (DecimalFormat)nf;
        formatoY.applyPattern(this.pattern2);
        g.setFont(this.fontNormal);
        double tmpy = -scatterPlot.getStepScalaY();
        while (tmpy < scatterPlot.getMaxESRange() - scatterPlot.getStepScalaY()) {
            if (!((tmpy += scatterPlot.getStepScalaY()) > scatterPlot.getMinESRange())) continue;
            g.drawLine(scatterPlot.marginLeft + scatterPlot.titleLeft - 3, scatterPlot.calcolaCoordinataY(tmpy), scatterPlot.marginLeft + scatterPlot.titleLeft + 3, scatterPlot.calcolaCoordinataY(tmpy));
            refLabel2 = new JLabel("" + formatoY.format(tmpy));
            refLabel2.setFont(this.fontNormal);
            refLabel2.setHorizontalAlignment(4);
            larghezzaLabel2 = (int)(scatterPlot.getStepScalaY() * scatterPlot.getyFP());
            refLabel2.setBounds(0, scatterPlot.calcolaCoordinataY(tmpy) - 10, scatterPlot.marginLeft + scatterPlot.titleLeft - 10, 20);
            this.add(refLabel2);
        }
        tmpy = 0.0;
        while (tmpy > scatterPlot.getMinESRange() + scatterPlot.getStepScalaY()) {
            if (!((tmpy -= scatterPlot.getStepScalaY()) < scatterPlot.getMaxESRange())) continue;
            g.drawLine(scatterPlot.marginLeft + scatterPlot.titleLeft - 3, scatterPlot.calcolaCoordinataY(tmpy), scatterPlot.marginLeft + scatterPlot.titleLeft + 3, scatterPlot.calcolaCoordinataY(tmpy));
            refLabel2 = new JLabel("" + formatoY.format(tmpy));
            refLabel2.setFont(this.fontNormal);
            refLabel2.setHorizontalAlignment(4);
            larghezzaLabel2 = (int)(scatterPlot.getStepScalaY() * scatterPlot.getyFP());
            refLabel2.setBounds(0, scatterPlot.calcolaCoordinataY(tmpy) - 10, scatterPlot.marginLeft + scatterPlot.titleLeft - 10, 20);
            this.add(refLabel2);
        }
        double tmp = -scatterPlot.getStepScalaX();
        while (tmp < scatterPlot.getMaxParameterRange() - scatterPlot.getStepScalaX()) {
            if (!((tmp += scatterPlot.getStepScalaX()) > scatterPlot.getMinParameterRange())) continue;
            g.drawLine(scatterPlot.calcolaCoordinataX(tmp), scatterPlot.marginTop + scatterPlot.titleTop + scatterPlot.altezzaUtile - 3, scatterPlot.calcolaCoordinataX(tmp), scatterPlot.marginTop + scatterPlot.titleTop + scatterPlot.altezzaUtile + 3);
            DecimalFormat formatoX = (DecimalFormat)nf;
            formatoX.applyPattern(this.pattern2);
            refLabel = new JLabel("" + formatoX.format(tmp));
            refLabel.setFont(this.fontNormal);
            refLabel.setHorizontalAlignment(0);
            larghezzaLabel = (int)(scatterPlot.getStepScalaX() * scatterPlot.getxFP());
            refLabel.setBounds(scatterPlot.calcolaCoordinataX(tmp) - larghezzaLabel / 2, scatterPlot.marginTop + scatterPlot.titleTop + scatterPlot.altezzaUtile + 15, larghezzaLabel, 20);
            this.add(refLabel);
        }
        tmp = 0.0;
        while (tmp > scatterPlot.getMinParameterRange() + scatterPlot.getStepScalaX()) {
            if (!((tmp -= scatterPlot.getStepScalaX()) < scatterPlot.getMaxParameterRange())) continue;
            g.drawLine(scatterPlot.calcolaCoordinataX(tmp), scatterPlot.marginTop + scatterPlot.titleTop + scatterPlot.altezzaUtile - 3, scatterPlot.calcolaCoordinataX(tmp), scatterPlot.marginTop + scatterPlot.titleTop + scatterPlot.altezzaUtile + 3);
            DecimalFormat valore = (DecimalFormat)nf;
            valore.applyPattern(this.pattern2);
            refLabel = new JLabel("" + valore.format(tmp));
            refLabel.setFont(this.fontNormal);
            refLabel.setHorizontalAlignment(0);
            larghezzaLabel = (int)(scatterPlot.getStepScalaX() * scatterPlot.getxFP());
            refLabel.setBounds(scatterPlot.calcolaCoordinataX(tmp) - larghezzaLabel / 2, scatterPlot.marginTop + scatterPlot.titleTop + scatterPlot.altezzaUtile + 15, larghezzaLabel, 20);
            this.add(refLabel);
        }
    }

    public void disegnaMargini(ScatterPlotHandler scatterPlot, Graphics g) {
        g.setColor(Color.MAGENTA);
        g.drawLine(0, this.scatterHandler.marginTop, this.larghezza, this.scatterHandler.marginTop);
        g.drawLine(0, this.altezza - this.scatterHandler.marginBottom, this.larghezza, this.altezza - this.scatterHandler.marginBottom);
        g.drawLine(this.scatterHandler.marginLeft, 0, this.scatterHandler.marginLeft, this.altezza);
        g.drawLine(this.larghezza - this.scatterHandler.marginRight, 0, this.larghezza - this.scatterHandler.marginRight, this.altezza);
        g.setColor(Color.blue);
        g.drawLine(0, this.scatterHandler.marginTop + this.scatterHandler.titleTop, this.larghezza, this.scatterHandler.marginTop + this.scatterHandler.titleTop);
        g.drawLine(0, this.altezza - this.scatterHandler.marginBottom - this.scatterHandler.titleBottom, this.larghezza, this.altezza - this.scatterHandler.marginBottom - this.scatterHandler.titleBottom);
        g.drawLine(this.scatterHandler.marginLeft + this.scatterHandler.titleLeft, 0, this.scatterHandler.marginLeft + this.scatterHandler.titleLeft, this.altezza);
        g.drawLine(this.larghezza - this.scatterHandler.marginRight - this.scatterHandler.titleRight, 0, this.larghezza - this.scatterHandler.marginRight - this.scatterHandler.titleRight, this.altezza);
    }

    public final void riempi() {
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.scatterHandler = new ScatterPlotHandler(this.graphInput.getRows(), this.larghezza, this.altezza);
        super.paintComponent(g);
        this.disegnaRettangolo(this.scatterHandler, g);
        this.disegnaTitoli(this.scatterHandler);
        this.disegnaScalaRif(this.scatterHandler, g);
        this.disegnaStudi(this.scatterHandler, g);
        this.disegnaRettaRegressione(this.scatterHandler, g);
    }
}

