/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.graph.scatterplot;

import java.util.List;
import metaanalysis.graph.scatterplot.ScatterPlotRow;

public class ScatterPlotHandler {
    protected List<ScatterPlotRow> rows;
    int larghezza;
    int altezza;
    int marginTop = 10;
    int marginBottom = 20;
    int marginRight = 10;
    int marginLeft = 10;
    int titleTop = 10;
    int titleBottom = 70;
    int titleRight = 10;
    int titleLeft = 70;
    private double minESRange;
    private double maxESRange;
    private double eSRange;
    private double minParameterRange;
    private double maxParameterRange;
    private double parameterRange;
    private double xFP;
    private double yFP;
    private double stepScalaX;
    private double stepScalaY;
    private double[] stepArray = new double[]{1.0E-4, 2.0E-4, 3.0E-4, 4.0E-4, 5.0E-4, 6.0E-4, 7.0E-4, 8.0E-4, 9.0E-4, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 2000.0, 3000.0, 4000.0, 5000.0, 6000.0, 7000.0, 8000.0, 9000.0, 10000.0};
    int altezzaUtile;
    int larghezzaUtile;
    double xRangeMargin;

    public ScatterPlotHandler(List<ScatterPlotRow> rows, int larghezza, int altezza) {
        this.rows = rows;
        this.larghezza = larghezza;
        this.altezza = altezza;
        this.altezzaUtile = this.altezza - this.marginTop - this.titleTop - this.marginBottom - this.titleBottom;
        this.larghezzaUtile = this.larghezza - this.marginLeft - this.titleLeft - this.marginRight - this.titleRight;
        this.xRangeMargin = (this.getMaxPredictor() - this.getMinPredictor()) / 10.0;
        this.minParameterRange = this.getMinPredictor() - this.xRangeMargin;
        this.maxParameterRange = this.getMaxPredictor() + this.xRangeMargin;
        this.parameterRange = this.getMaxPredictor() - this.getMinPredictor() + 2.0 * this.xRangeMargin;
        double yRangeMargin = (this.getMaxES() - this.getMinES()) / 6.0;
        this.minESRange = this.getMinES() - yRangeMargin;
        this.maxESRange = this.getMaxES() + yRangeMargin;
        this.eSRange = this.getMaxES() - this.getMinES() + 2.0 * yRangeMargin;
        this.yFP = (double)this.altezzaUtile / this.eSRange;
        this.xFP = (double)this.larghezzaUtile / this.parameterRange;
        this.stepScalaX = this.stepScalaX();
        this.stepScalaY = this.stepScalaY();
    }

    public final double getMaxES() {
        double maxES = -99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getEffectSize() > maxES)) continue;
            maxES = this.rows.get(i).getEffectSize();
        }
        return maxES;
    }

    public final double getMinES() {
        double minES = 99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getEffectSize() < minES)) continue;
            minES = this.rows.get(i).getEffectSize();
        }
        return minES;
    }

    public final double getMaxPredictor() {
        double maxParameter = -99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getPredictor() > maxParameter)) continue;
            maxParameter = this.rows.get(i).getPredictor();
        }
        return maxParameter;
    }

    public final double getMinPredictor() {
        double minParameter = 99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getPredictor() < minParameter)) continue;
            minParameter = this.rows.get(i).getPredictor();
        }
        return minParameter;
    }

    public double getMaxWeight() {
        double maxWeight = -99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getWeight() > maxWeight)) continue;
            maxWeight = this.rows.get(i).getWeight();
        }
        return maxWeight;
    }

    public double getMinWeight() {
        double minWeight = 99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getWeight() < minWeight)) continue;
            minWeight = this.rows.get(i).getWeight();
        }
        return minWeight;
    }

    public int dimensionaCerchi(int i) {
        int raggioMax = this.altezza / 20;
        int raggioMin = this.altezza / 120;
        return (int)(this.rows.get(i).getWeight() * ((double)raggioMax / this.getMaxWeight()) + (double)raggioMin);
    }

    public int calcolaCoordinataX(double xValue) {
        return this.marginLeft + this.titleLeft + (int)((xValue - this.minParameterRange) * this.xFP);
    }

    public int calcolaCoordinataY(double yValue) {
        return this.marginTop + this.titleTop + this.altezzaUtile - (int)((yValue - this.minESRange) * this.yFP);
    }

    public final double stepScalaX() {
        double nTacche = 0.0;
        double nTaccheVoluteX = 7.0;
        if (this.larghezza < 200) {
            nTaccheVoluteX = 3.0;
        }
        if (this.larghezza >= 200 && this.larghezza < 300) {
            nTaccheVoluteX = 3.0;
        }
        if (this.larghezza >= 300 && this.larghezza < 500) {
            nTaccheVoluteX = 4.0;
        }
        if (this.larghezza >= 500 && this.larghezza < 600) {
            nTaccheVoluteX = 5.0;
        }
        if (this.larghezza >= 650 && this.larghezza < 700) {
            nTaccheVoluteX = 6.0;
        }
        if (this.larghezza > 950) {
            nTaccheVoluteX = 7.0;
        }
        int count = 0;
        for (int i = 1; i < this.stepArray.length; ++i) {
            nTacche = this.parameterRange / this.stepArray[i];
            if (!(nTacche < nTaccheVoluteX)) continue;
            count = i - 1;
            break;
        }
        return this.stepArray[count];
    }

    public final double stepScalaY() {
        double nTacche = 0.0;
        double nTaccheVoluteY = 8.0;
        if (this.altezza < 100) {
            nTaccheVoluteY = 3.0;
        }
        if (this.altezza >= 100 && this.altezza < 200) {
            nTaccheVoluteY = 3.0;
        }
        if (this.altezza >= 200 && this.altezza < 300) {
            nTaccheVoluteY = 4.0;
        }
        if (this.altezza >= 300 && this.altezza < 400) {
            nTaccheVoluteY = 5.0;
        }
        if (this.altezza >= 400 && this.altezza < 500) {
            nTaccheVoluteY = 6.0;
        }
        if (this.altezza >= 500 && this.altezza < 700) {
            nTaccheVoluteY = 7.0;
        }
        if (this.altezza > 700) {
            nTaccheVoluteY = 8.0;
        }
        int count = 0;
        for (int i = 1; i < this.stepArray.length; ++i) {
            nTacche = this.eSRange / this.stepArray[i];
            if (!(nTacche < nTaccheVoluteY)) continue;
            count = i - 1;
            break;
        }
        return this.stepArray[count];
    }

    public double arrotonda(double numero, int nCifreDecimali) {
        return (double)Math.round(numero * Math.pow(10.0, nCifreDecimali)) / Math.pow(10.0, nCifreDecimali);
    }

    public double geteSRange() {
        return this.eSRange;
    }

    public double getMaxESRange() {
        return this.maxESRange;
    }

    public double getMinESRange() {
        return this.minESRange;
    }

    public double getParameterRange() {
        return this.parameterRange;
    }

    public double getMaxParameterRange() {
        return this.maxParameterRange;
    }

    public double getMinParameterRange() {
        return this.minParameterRange;
    }

    public double getStepScalaX() {
        return this.stepScalaX;
    }

    public double getStepScalaY() {
        return this.stepScalaY;
    }

    public double getxFP() {
        return this.xFP;
    }

    public double getyFP() {
        return this.yFP;
    }

    public double getxRangeMargin() {
        return this.xRangeMargin;
    }
}

