/*
 * Decompiled with CFR 0.152.
 */
package metaanlysis.dtabase.embedded;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class UtilAssemblerFunctions {
    public static void cleanAll() throws Exception {
        Connection conn = null;
        if (conn == null || conn.isClosed()) {
            conn = DriverManager.getConnection("jdbc:derby:CustDB;create=true", "app", "app");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Connection refused");
        }
        try {
            stmt.execute("DROP TABLE moderatorvalue");
        }
        catch (Exception ex) {
            throw new Exception("moderatorvalue");
        }
        try {
            stmt.execute("DROP TABLE categoricaldefaultvalue");
        }
        catch (Exception ex) {
            throw new Exception("categoricaldefaultvalue");
        }
        try {
            stmt.execute("DROP TABLE outcomebranch");
        }
        catch (Exception ex) {
            throw new Exception("outcomebranch");
        }
        try {
            stmt.execute("DROP TABLE timepointbranch");
        }
        catch (Exception ex) {
            throw new Exception("timepointbranch");
        }
        try {
            stmt.execute("DROP TABLE comparisonbranch");
        }
        catch (Exception ex) {
            throw new Exception("comparisonbranch");
        }
        try {
            stmt.execute("DROP TABLE subgroupbranch");
        }
        catch (Exception ex) {
            throw new Exception("subgroupbranch");
        }
        try {
            stmt.execute("DROP TABLE moderatorlevel");
        }
        catch (Exception ex) {
            throw new Exception("moderatorlevel");
        }
        try {
            stmt.execute("DROP TABLE moderatorrecode");
        }
        catch (Exception ex) {
            throw new Exception("moderatorrecode");
        }
        try {
            stmt.execute("DROP TABLE preanalysis");
        }
        catch (Exception ex) {
            throw new Exception("preanalysis");
        }
        try {
            stmt.execute("DROP TABLE project");
        }
        catch (Exception ex) {
            throw new Exception("project");
        }
        try {
            stmt.execute("DROP TABLE study");
        }
        catch (Exception ex) {
            throw new Exception("study");
        }
        try {
            stmt.execute("DROP TABLE moderator");
        }
        catch (Exception ex) {
            throw new Exception("moderator");
        }
        try {
            stmt.execute("DROP TABLE longidgen");
        }
        catch (Exception ex) {
            throw new Exception("longidgen");
        }
        try {
            stmt.execute("DROP TABLE outcome");
        }
        catch (Exception ex) {
            throw new Exception("outcome");
        }
        try {
            stmt.execute("DROP TABLE comparison");
        }
        catch (Exception ex) {
            throw new Exception("comparison");
        }
        try {
            stmt.execute("DROP TABLE subgroup");
        }
        catch (Exception ex) {
            throw new Exception("subgroup");
        }
        try {
            stmt.execute("DROP TABLE topic");
        }
        catch (Exception ex) {
            throw new Exception("topic");
        }
        conn.close();
    }

    public static void createAll() throws Exception {
        Connection conn = null;
        if (conn == null || conn.isClosed()) {
            conn = DriverManager.getConnection("jdbc:derby:CustDB;create=true", "app", "app");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Connection refused");
        }
        try {
            stmt.execute("CREATE TABLE longidgen ( id bigint primary key generated by default as identity (START WITH 1, INCREMENT BY 1))");
            stmt.execute("CREATE TABLE topic (id bigint primary key, lastmodify BIGINT, name VARCHAR(255), topictype int, preanalysis VARCHAR(32640), status VARCHAR(50), description VARCHAR(255), note VARCHAR(255), version int)");
            stmt.execute("CREATE TABLE study ( id BIGINT REFERENCES longidgen ON DELETE CASCADE ON UPDATE RESTRICT , name VARCHAR(255) , description VARCHAR(255) , note VARCHAR(255) , topic_id bigint CONSTRAINT studytopic_foreign_key REFERENCES topic ON DELETE CASCADE ON UPDATE RESTRICT, primary key (id))");
            stmt.execute("CREATE TABLE subgroup ( id int primary key , name VARCHAR(255) , description VARCHAR(255) , note VARCHAR(255) , topic_id bigint CONSTRAINT subgrouptopic_foreign_key REFERENCES topic ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.execute("CREATE TABLE comparison ( id int primary key , name VARCHAR(255) , description VARCHAR(255) , note VARCHAR(255) , topic_id bigint CONSTRAINT comparisontopic_foreign_key REFERENCES topic ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.execute("CREATE TABLE outcome ( id int primary key, name VARCHAR(255) , description VARCHAR(255) , note VARCHAR(255) , groupa VARCHAR(255) , groupb VARCHAR(255) , event VARCHAR(255) , nonevent VARCHAR(255) , topic_id bigint CONSTRAINT outcometopic_foreign_key REFERENCES topic ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.execute("CREATE TABLE project ( id int primary key , name VARCHAR(255), description VARCHAR(255), note VARCHAR(255), filter VARCHAR(8192), topic_id bigint CONSTRAINT projecttopic_foreign_key REFERENCES topic ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.execute("CREATE TABLE preanalysis ( id int primary key , name VARCHAR(255), description VARCHAR(255), note VARCHAR(255), filter VARCHAR(8192), topic_id bigint CONSTRAINT preanalysistopic_foreign_key REFERENCES topic ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.execute("CREATE TABLE moderator ( id int primary key, name VARCHAR(255) , description VARCHAR(255) , moderatortype INT , defvalues VARCHAR(4080) , note VARCHAR(255), systemlevel VARCHAR(50), topic_id bigint CONSTRAINT moderatortopic_foreign_key REFERENCES topic ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.execute("CREATE TABLE moderatorlevel ( moderator_id int REFERENCES moderator ON DELETE CASCADE ON UPDATE RESTRICT, study_id BIGINT REFERENCES study ON DELETE CASCADE ON UPDATE RESTRICT , moderatorlevel INT , primary key (moderator_id, study_id))");
            stmt.execute("CREATE TABLE subgroupbranch ( id BIGINT REFERENCES longidgen ON DELETE CASCADE ON UPDATE RESTRICT  , study_id bigint CONSTRAINT subgroupbranch_study_foreign_key REFERENCES study ON DELETE CASCADE ON UPDATE RESTRICT , subgroup_id int CONSTRAINT subgroupbranch_subgroup_foreign_key REFERENCES subgroup ON DELETE CASCADE ON UPDATE RESTRICT, primary key (id))");
            stmt.execute("CREATE TABLE comparisonbranch ( id BIGINT REFERENCES longidgen ON DELETE CASCADE ON UPDATE RESTRICT , comparison_id int CONSTRAINT comparisonbranch_comparison_foreign_key REFERENCES comparison ON DELETE CASCADE ON UPDATE RESTRICT, subgroupbranch_id BIGINT CONSTRAINT comparisonbranch_subgroupbranch_foreign_key REFERENCES subgroupbranch ON DELETE CASCADE ON UPDATE RESTRICT, primary key (id))");
            stmt.execute("CREATE TABLE timepointbranch ( id BIGINT REFERENCES longidgen ON DELETE CASCADE ON UPDATE RESTRICT , timepoint_id int , comparisonbranch_id BIGINT CONSTRAINT timepointbranch_comparisonbranch_foreign_key REFERENCES comparisonbranch ON DELETE CASCADE ON UPDATE RESTRICT, primary key (id))");
            stmt.execute("CREATE TABLE outcomebranch ( id BIGINT REFERENCES longidgen ON DELETE CASCADE ON UPDATE RESTRICT  , outcome_id int CONSTRAINT outcomebranch_outcome_foreign_key REFERENCES outcome ON DELETE CASCADE ON UPDATE RESTRICT, effectsizevalue VARCHAR(16384), timepointbranch_id BIGINT CONSTRAINT outcomebranch_timepointbranch_foreign_key REFERENCES timepointbranch ON DELETE CASCADE ON UPDATE RESTRICT, primary key (id))");
            stmt.execute("CREATE TABLE moderatorrecode ( id BIGINT primary key , name VARCHAR(255) , moderatorRecodingMachine VARCHAR(16320) , description VARCHAR(255) , note VARCHAR(255) , moderator_id int CONSTRAINT moderatorrecode_moderator_foreign_key REFERENCES moderator ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.execute("insert into subgroup values(-1,'* No-subgroup','','',null)");
            stmt.execute("insert into comparison values(-1,'* No-comparison','','',null)");
            stmt.execute("CREATE TABLE moderatorvalue ( moderator_id int REFERENCES moderator ON DELETE CASCADE ON UPDATE RESTRICT , study_id BIGINT REFERENCES study ON DELETE CASCADE ON UPDATE RESTRICT ,  longidgen_id BIGINT REFERENCES longidgen ON DELETE CASCADE ON UPDATE RESTRICT , moderatortype int, categoricalvalue VARCHAR(1024), integervalue int, continuousvalue double, note VARCHAR(255), primary key (moderator_id, study_id, longidgen_id) )");
            stmt.execute("CREATE TABLE categoricaldefaultvalue ( id BIGINT primary key, modvalue VARCHAR(255), moderator_id int CONSTRAINT moderatorcategoricaldefvalues_foreign_key REFERENCES moderator ON DELETE CASCADE ON UPDATE RESTRICT)");
            stmt.close();
        }
        catch (SQLException ex) {
            conn.close();
            throw ex;
        }
    }
}

