/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations;

import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsize.api.BinarySampleSizeValueImpl;
import metaanalysis.effectsizes.models.ESRConversions;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.LogOddsRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.LogPetoOddsRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.LogRiskRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.OddsRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.PetoOddsRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RiskDifferenceEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RiskRatioEffectSizeResults;
import org.openide.util.NbBundle;

public abstract class ABinaryESFormat
extends AbstractEffectSizeValue {
    private int eventsA;
    private int eventsB;
    private boolean zeroAdded = false;
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected double n1;
    protected double n2;
    private int notEventsA;
    private int notEventsB;

    public ABinaryESFormat() {
    }

    public ABinaryESFormat(int effectDirection, double confidenceInterval, int eventsA, int eventsB, int n1, int n2) {
        super(confidenceInterval, effectDirection, new BinarySampleSizeValueImpl(n1, n2));
        this.eventsA = eventsA;
        this.eventsB = eventsB;
        this.notEventsA = n1 - this.eventsA;
        this.notEventsB = n2 - this.eventsB;
        this.a = eventsA;
        this.b = (double)n1 - this.a;
        this.c = eventsB;
        this.d = (double)n2 - this.c;
        this.n1 = n1;
        this.n2 = n2;
        if (this.a == 0.0 || this.b == 0.0 || this.c == 0.0 || this.d == 0.0) {
            this.zeroAdded = true;
            this.addFor0();
        }
    }

    private void addFor0() {
        this.a += 0.5;
        this.b += 0.5;
        this.c += 0.5;
        this.d += 0.5;
        this.n1 += 1.0;
        this.n2 += 1.0;
    }

    private void resetFor0() {
        this.a -= 0.5;
        this.b -= 0.5;
        this.c -= 0.5;
        this.d -= 0.5;
        this.n1 -= 1.0;
        this.n2 -= 1.0;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public double getD() {
        return this.d;
    }

    public double getN1() {
        return this.n1;
    }

    public double getN2() {
        return this.n2;
    }

    public int getEventsA() {
        return this.eventsA;
    }

    public int getEventsB() {
        return this.eventsB;
    }

    public void setEventsA(int eventsA) {
        this.eventsA = eventsA;
    }

    public void setEventsB(int eventsB) {
        this.eventsB = eventsB;
    }

    public int getNotEventsA() {
        return this.notEventsA;
    }

    public void setNotEventsA(int notEventsA) {
        this.notEventsA = notEventsA;
    }

    public int getNotEventsB() {
        return this.notEventsB;
    }

    public void setNotEventsB(int notEventsB) {
        this.notEventsB = notEventsB;
    }

    @Override
    protected void fillAllConversions() {
        assert (this.getLogOddsRatioEffectSizeResults() != null) : "ASSERT ERROR: " + this.getClass().getName() + " doesn't implement Log Odds Ratio effect size";
        this.setCohensDEffectSizeResults(ESRConversions.fromLogOddsRatioToChoenD((LogOddsRatioEffectSizeResults)this.getLogOddsRatioEffectSizeResults(), (double)this.confidenceInterval));
        if (this.zeroAdded) {
            this.resetFor0();
        }
        double t = this.a + this.b + this.c + this.d;
        double o = this.a;
        double e = (this.a + this.b) * (this.a + this.c) / t;
        double v = (this.a + this.b) * (this.c + this.d) * (this.a + this.c) * (this.b + this.d) / (Math.pow(t, 2.0) * (t - 1.0));
        this.setLogPetoOddsRatioEffectSizeResults(new LogPetoOddsRatioEffectSizeResults());
        this.getLogPetoOddsRatioEffectSizeResults().setEffectSize(Double.valueOf((o - e) / v));
        this.getLogPetoOddsRatioEffectSizeResults().setVariance(Double.valueOf(1.0 / v));
        this.getLogPetoOddsRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.setPetoOddsRatioEffectSizeResults(new PetoOddsRatioEffectSizeResults());
        this.getPetoOddsRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.exp(this.getLogPetoOddsRatioEffectSizeResults().getEffectSize())));
        this.getPetoOddsRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.exp(this.getLogPetoOddsRatioEffectSizeResults().getLowerLimit())));
        this.getPetoOddsRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.exp(this.getLogPetoOddsRatioEffectSizeResults().getUpperLimit())));
        this.getPetoOddsRatioEffectSizeResults().setPValue(this.getLogPetoOddsRatioEffectSizeResults().getPValue());
        if (this.zeroAdded) {
            this.addFor0();
        }
        this.convertFromChoensToCorrelations();
        this.convertFromChoensToHedgesG(this.iSampleSizeValue.getSampleSize() - 1);
        if (this.zeroAdded) {
            this.resetFor0();
            this.zeroAdded = false;
        }
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setRiskRatioEffectSizeResults(new RiskRatioEffectSizeResults());
        this.getRiskRatioEffectSizeResults().setEffectSize(Double.valueOf(1.0 * this.getA() / this.getN1() / (1.0 * this.getC() / this.getN2())));
        this.setLogRiskRatioEffectSizeResults(new LogRiskRatioEffectSizeResults());
        this.getLogRiskRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getRiskRatioEffectSizeResults().getEffectSize())));
        this.getLogRiskRatioEffectSizeResults().setVariance(Double.valueOf(1.0 / this.getA() - 1.0 / this.getN1() + 1.0 / this.getC() - 1.0 / this.getN2()));
        this.getLogRiskRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.getRiskRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.exp(this.getLogRiskRatioEffectSizeResults().getUpperLimit())));
        this.getRiskRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.exp(this.getLogRiskRatioEffectSizeResults().getLowerLimit())));
        this.getRiskRatioEffectSizeResults().setPValue(this.getLogRiskRatioEffectSizeResults().getPValue());
        this.getRiskRatioEffectSizeResults().setZValue(this.getLogRiskRatioEffectSizeResults().getZValue());
        this.setOddsRatioEffectSizeResults(new OddsRatioEffectSizeResults());
        this.getOddsRatioEffectSizeResults().setEffectSize(Double.valueOf(1.0 * this.getA() * this.getD() / (this.getB() * this.getC())));
        this.setLogOddsRatioEffectSizeResults(new LogOddsRatioEffectSizeResults());
        this.getLogOddsRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getOddsRatioEffectSizeResults().getEffectSize())));
        this.getLogOddsRatioEffectSizeResults().setVariance(Double.valueOf(1.0 / this.getA() + 1.0 / this.getB() + 1.0 / this.getC() + 1.0 / this.getD()));
        this.getLogOddsRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.getOddsRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.exp(this.getLogOddsRatioEffectSizeResults().getUpperLimit())));
        this.getOddsRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.exp(this.getLogOddsRatioEffectSizeResults().getLowerLimit())));
        this.getOddsRatioEffectSizeResults().setPValue(this.getLogOddsRatioEffectSizeResults().getPValue());
        this.getOddsRatioEffectSizeResults().setZValue(this.getLogOddsRatioEffectSizeResults().getZValue());
        this.setRiskDifferenceEffectSizeResults(new RiskDifferenceEffectSizeResults());
        if (this.zeroAdded) {
            this.resetFor0();
        }
        this.getRiskDifferenceEffectSizeResults().setEffectSize(Double.valueOf(this.getA() / this.getN1() - this.getC() / this.getN2()));
        if (this.zeroAdded) {
            this.addFor0();
        }
        this.getRiskDifferenceEffectSizeResults().setVariance(Double.valueOf(1.0 * this.getA() * this.getB() / Math.pow(this.getN1(), 3.0) + 1.0 * this.getC() * this.getD() / Math.pow(this.getN2(), 3.0)));
        this.getRiskDifferenceEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"binaryCategory");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logOddsRatioLabel");
    }
}

