/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations;

import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsize.api.BinaryMatchedSampleSizeValueImpl;
import metaanalysis.effectsizes.models.ESRConversions;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.LogOddsRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.OddsRatioEffectSizeResults;
import org.openide.util.NbBundle;

public abstract class ABinaryMatchedVsLongitudinalVsCrossESFormat
extends AbstractEffectSizeValue {
    protected int eventA;
    protected int eventB;
    protected int nonEventA;
    protected int nonEventB;
    protected double varA;
    protected double varB;
    protected double varC;
    protected double varD;
    protected double correlation;
    protected double n;
    protected boolean zeroAdded = false;

    public ABinaryMatchedVsLongitudinalVsCrossESFormat() {
    }

    public ABinaryMatchedVsLongitudinalVsCrossESFormat(double confidenceInterval, int groupAEvent, int groupANonEvent, int groupBEvent, int groupBNonEvent, double correlation) {
        super(confidenceInterval, 1, new BinaryMatchedSampleSizeValueImpl(groupAEvent + groupANonEvent + groupBEvent + groupBNonEvent));
        this.varA = groupAEvent;
        this.varB = groupANonEvent;
        this.varC = groupBEvent;
        this.varD = groupBNonEvent;
        this.eventA = groupAEvent;
        this.eventB = groupBEvent;
        this.nonEventA = groupANonEvent;
        this.nonEventB = groupBNonEvent;
        if (this.varA == 0.0 || this.varB == 0.0 || this.varC == 0.0 || this.varD == 0.0) {
            this.zeroAdded = true;
            this.varA += 0.5;
            this.varB += 0.5;
            this.varC += 0.5;
            this.varD += 0.5;
        }
        this.n = (1.0 * this.varA + this.varB + this.varC + this.varD) / 2.0;
        this.correlation = correlation;
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(double correlation) {
        this.correlation = correlation;
    }

    public int getEventA() {
        return this.eventA;
    }

    public void setEventA(int eventA) {
        this.eventA = eventA;
    }

    public int getEventB() {
        return this.eventB;
    }

    public void setEventB(int eventB) {
        this.eventB = eventB;
    }

    public int getNonEventA() {
        return this.nonEventA;
    }

    public void setNonEventA(int nonEventA) {
        this.nonEventA = nonEventA;
    }

    public int getNonEventB() {
        return this.nonEventB;
    }

    public void setNonEventB(int nonEventB) {
        this.nonEventB = nonEventB;
    }

    public double getN() {
        return this.n;
    }

    public void setN(double n) {
        this.n = n;
    }

    public double getVarA() {
        return this.varA;
    }

    public void setVarA(double varA) {
        this.varA = varA;
    }

    public double getVarB() {
        return this.varB;
    }

    public void setVarB(double varB) {
        this.varB = varB;
    }

    public double getVarC() {
        return this.varC;
    }

    public void setVarC(double varC) {
        this.varC = varC;
    }

    public double getVarD() {
        return this.varD;
    }

    public void setVarD(double varD) {
        this.varD = varD;
    }

    public boolean isZeroAdded() {
        return this.zeroAdded;
    }

    public void setZeroAdded(boolean zeroAdded) {
        this.zeroAdded = zeroAdded;
    }

    @Override
    protected void fillAllConversions() {
        assert (this.getLogOddsRatioEffectSizeResults() != null) : "ASSERT ERROR: " + this.getClass().getName() + " doesn't implement Log Odds Ratio effect size";
        this.setCohensDEffectSizeResults(ESRConversions.fromLogOddsRatioToChoenD((LogOddsRatioEffectSizeResults)this.getLogOddsRatioEffectSizeResults(), (double)this.confidenceInterval));
        this.convertFromChoensToCorrelations();
        this.convertFromChoensToHedgesG(this.iSampleSizeValue.getSampleSize() - 2);
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setOddsRatioEffectSizeResults(new OddsRatioEffectSizeResults());
        this.getOddsRatioEffectSizeResults().setEffectSize(Double.valueOf(1.0 * this.getVarA() * this.getVarD() / (this.getVarB() * this.getVarC())));
        this.setLogOddsRatioEffectSizeResults(new LogOddsRatioEffectSizeResults());
        this.getLogOddsRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getOddsRatioEffectSizeResults().getEffectSize())));
        double j = 2.0 * this.n * this.correlation / Math.sqrt(this.varA * this.varB * this.varC * this.varD);
        this.getLogOddsRatioEffectSizeResults().setVariance(Double.valueOf(1.0 / this.getVarA() + 1.0 / this.getVarB() + 1.0 / this.getVarC() + 1.0 / this.getVarD() - j));
        this.getLogOddsRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.getOddsRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.exp(this.getLogOddsRatioEffectSizeResults().getUpperLimit())));
        this.getOddsRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.exp(this.getLogOddsRatioEffectSizeResults().getLowerLimit())));
        this.getOddsRatioEffectSizeResults().setPValue(this.getLogOddsRatioEffectSizeResults().getPValue());
        this.getOddsRatioEffectSizeResults().setZValue(this.getLogOddsRatioEffectSizeResults().getZValue());
    }

    public String getEffectSizeValueCategory() {
        return "Binary data";
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logOddsRatioLabel");
    }
}

