/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations;

import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import org.openide.util.NbBundle;

public abstract class AContinuousESFormat
extends AbstractEffectSizeValue {
    public static int standardizedByPost_standard_deviation = 0;
    public static int standardizedByChange_score_standard_deviation = 1;
    public static final String[] standardizeByLabels = new String[]{NbBundle.getMessage(AContinuousESFormat.class, (String)"Post_standard_deviation"), NbBundle.getMessage(AContinuousESFormat.class, (String)"Change_score_standard_deviation")};
    public static double standardCorrelationValueForMeans = 0.5;
    private double correlation = standardCorrelationValueForMeans;

    public static int getStandardizeByLabel(String s) {
        for (int i = 0; i < standardizeByLabels.length; ++i) {
            if (!s.equals(standardizeByLabels[i])) continue;
            return i;
        }
        return 0;
    }

    public AContinuousESFormat() {
    }

    public AContinuousESFormat(double confidenceInterval, int effectDirection, ISampleSizeValue iSampleSizeValue, double correlation) {
        super(confidenceInterval, effectDirection, iSampleSizeValue);
        this.correlation = correlation;
    }

    public AContinuousESFormat(double confidenceInterval, int effectDirection, ISampleSizeValue iSampleSizeValue) {
        super(confidenceInterval, effectDirection, iSampleSizeValue);
    }

    @Override
    protected void fillAllConversions() {
        assert (this.getCohensDEffectSizeResults() != null) : NbBundle.getMessage(AContinuousESFormat.class, (String)"assert.choensDnotImplemented", (Object)this.getClass().getName());
        this.convertFromChoensToBynaryData();
        this.convertFromChoensToCorrelations();
        this.convertFromChoensToHedgesG(this.iSampleSizeValue.getSampleSize() - 1);
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"meanCategory");
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"hedgessGLabel");
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(double correlation) {
        this.correlation = correlation;
    }
}

