/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.binary;

import metaanalysis.effectsize.api.BinaryMatchedSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.ABinaryMatchedVsLongitudinalVsCrossESFormat;

public abstract class ABinaryMLC2x2StandardES
extends ABinaryMatchedVsLongitudinalVsCrossESFormat {
    private int eventAeventB;
    private int eventAnonEventB;
    private int nonEventAeventB;
    private int nonEventAnonEventB;
    private double varS;
    private double varT;
    private double varU;
    private double varV;

    public ABinaryMLC2x2StandardES() {
    }

    public ABinaryMLC2x2StandardES(double confidenceInterval, int eventAeventB, int eventAnonEventB, int nonEventAeventB, int nonEventAnonEventB) {
        this.eventAeventB = eventAeventB;
        this.eventAnonEventB = eventAnonEventB;
        this.nonEventAeventB = nonEventAeventB;
        this.nonEventAnonEventB = nonEventAnonEventB;
        this.varS = eventAeventB;
        this.varT = eventAnonEventB;
        this.varU = nonEventAeventB;
        this.varV = nonEventAnonEventB;
        this.varA = this.varS + this.varT;
        this.varB = this.varU + this.varV;
        this.varC = this.varS + this.varU;
        this.varD = this.varT + this.varV;
        if (this.varA == 0.0 || this.varB == 0.0 || this.varC == 0.0 || this.varD == 0.0) {
            this.zeroAdded = true;
            this.varA += 0.5;
            this.varB += 0.5;
            this.varC += 0.5;
            this.varD += 0.5;
        }
        this.n = (1.0 * this.varA + this.varB + this.varC + this.varD) / 2.0;
        this.iSampleSizeValue = new BinaryMatchedSampleSizeValueImpl(2 * (eventAeventB + eventAnonEventB + nonEventAeventB + nonEventAnonEventB));
        this.correlation = (1.0 * (this.n * this.varS) - this.varA * this.varC) / Math.sqrt(this.varA * this.varB * this.varC * this.varD);
    }

    public double getVarS() {
        return this.varS;
    }

    public void setVarS(double varS) {
        this.varS = varS;
    }

    public double getVarT() {
        return this.varT;
    }

    public void setVarT(double varT) {
        this.varT = varT;
    }

    public double getVarU() {
        return this.varU;
    }

    public void setVarU(double varU) {
        this.varU = varU;
    }

    public double getVarV() {
        return this.varV;
    }

    public void setVarV(double varV) {
        this.varV = varV;
    }

    public void setVarV(int varV) {
        this.varV = varV;
    }

    public int getEventAeventB() {
        return this.eventAeventB;
    }

    public void setEventAeventB(int eventAeventB) {
        this.eventAeventB = eventAeventB;
    }

    public int getEventAnonEventB() {
        return this.eventAnonEventB;
    }

    public void setEventAnonEventB(int eventAnonEventB) {
        this.eventAnonEventB = eventAnonEventB;
    }

    public int getNonEventAeventB() {
        return this.nonEventAeventB;
    }

    public void setNonEventAeventB(int nonEventAeventB) {
        this.nonEventAeventB = nonEventAeventB;
    }

    public int getNonEventAnonEventB() {
        return this.nonEventAnonEventB;
    }

    public void setNonEventAnonEventB(int nonEventAnonEventB) {
        this.nonEventAnonEventB = nonEventAnonEventB;
    }
}

