/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.binary;

import java.io.Serializable;
import metaanalysis.effectsize.api.BinarySampleSizeValueImpl;
import metaanalysis.effectsize.implementations.ACorrelationESFormat;
import metaanalysis.effectsizes.models.ESRConversions;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CorrelationEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.FishersZEffectSizeResults;
import org.openide.util.NbBundle;

public class BinaryIndipendentGroupsProspective_ChiSquare_ForEachGroup
extends ACorrelationESFormat
implements IEffectSizeValue,
Serializable {
    private double chiSqure;

    public BinaryIndipendentGroupsProspective_ChiSquare_ForEachGroup(int effectDirection, double confidenceInterval, double chiSqure, Integer n1, Integer n2) {
        super(confidenceInterval, effectDirection, new BinarySampleSizeValueImpl(n1, n2));
        this.chiSqure = chiSqure;
    }

    public BinaryIndipendentGroupsProspective_ChiSquare_ForEachGroup(int effectDirection, double confidenceInterval, double chiSqure, Integer globalSampleSize) {
        super(confidenceInterval, effectDirection, new BinarySampleSizeValueImpl(globalSampleSize));
        this.chiSqure = chiSqure;
    }

    public BinaryIndipendentGroupsProspective_ChiSquare_ForEachGroup() {
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel");
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setCorrelationEffectSizeResults(new CorrelationEffectSizeResults());
        this.setFishersZEffectSizeResults(new FishersZEffectSizeResults());
        this.getCorrelationEffectSizeResults().setEffectSize(Math.sqrt(this.chiSqure / (double)this.getISampleSizeValue().getSampleSize()), this.effectDirection);
        this.getFishersZEffectSizeResults().setEffectSize(0.5 * Math.log((1.0 + this.getCorrelationEffectSizeResults().getEffectSize()) / (1.0 - this.getCorrelationEffectSizeResults().getEffectSize())), this.effectDirection);
        this.getFishersZEffectSizeResults().setVariance(Double.valueOf(1.0 / (double)(this.getISampleSizeValue().getSampleSize() - 3)));
        this.getFishersZEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.getCorrelationEffectSizeResults().setUpperLimit(Double.valueOf(ESRConversions.simpleConversionFromFisherToR((double)this.getFishersZEffectSizeResults().getUpperLimit())));
        this.getCorrelationEffectSizeResults().setLowerLimit(Double.valueOf(ESRConversions.simpleConversionFromFisherToR((double)this.getFishersZEffectSizeResults().getLowerLimit())));
        this.getCorrelationEffectSizeResults().setStandardError(Double.valueOf((1.0 - Math.pow(this.getCorrelationEffectSizeResults().getEffectSize(), 2.0)) * this.getFishersZEffectSizeResults().getStandardError()));
        this.getCorrelationEffectSizeResults().setVariance(Double.valueOf(Math.pow(this.getCorrelationEffectSizeResults().getStandardError(), 2.0)));
        this.getCorrelationEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.getCorrelationEffectSizeResults().setUpperLimit(Double.valueOf(ESRConversions.simpleConversionFromFisherToR((double)this.getFishersZEffectSizeResults().getUpperLimit())));
        this.getCorrelationEffectSizeResults().setLowerLimit(Double.valueOf(ESRConversions.simpleConversionFromFisherToR((double)this.getFishersZEffectSizeResults().getLowerLimit())));
    }

    @Override
    public String getEffectSizeValueCategory() {
        return "Binary data";
    }

    public double getChiSqure() {
        return this.chiSqure;
    }

    public void setChiSqure(double chiSqure) {
        this.chiSqure = chiSqure;
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"binaryIndipendentGroupsCategory");
    }

    public String getName() {
        return NbBundle.getMessage(BinaryIndipendentGroupsProspective_ChiSquare_ForEachGroup.class, (String)"Chi_Square_Sample_size_igp_feg");
    }

    @Override
    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logOddsRatioLabel");
    }
}

