/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.binary;

import java.io.Serializable;
import metaanalysis.effectsize.implementations.ADirectESFormat;
import metaanalysis.effectsizes.models.ESRConversions;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.LogOddsRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.OddsRatioEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DirectESOddsRatio
extends ADirectESFormat
implements IEffectSizeValue,
Serializable {
    public DirectESOddsRatio(double confidenceInterval, double directEffectSize, double directLowerLimit, double directUpperLimit, double interval, int sampleSize) {
        super(confidenceInterval, directEffectSize, directLowerLimit, directUpperLimit, interval, sampleSize);
    }

    public DirectESOddsRatio() {
    }

    @Override
    protected void fillAllConversions() {
        assert (this.getLogOddsRatioEffectSizeResults() != null) : "ASSERT ERROR: " + this.getClass().getName() + " doesn't implement Log Odds Ratio effect size";
        this.setCohensDEffectSizeResults(ESRConversions.fromLogOddsRatioToChoenD((LogOddsRatioEffectSizeResults)this.getLogOddsRatioEffectSizeResults(), (double)this.confidenceInterval));
        this.convertFromChoensToCorrelations();
        this.convertFromChoensToHedgesG(this.getISampleSizeValue().getSampleSize() - 2);
    }

    @Override
    protected void elaborateOwnEffectSize() {
        try {
            this.setOddsRatioEffectSizeResults(new OddsRatioEffectSizeResults());
            this.getOddsRatioEffectSizeResults().setEffectSize(Double.valueOf(this.getDirectEffectSize()));
            this.getOddsRatioEffectSizeResults().setUpperLimit(Double.valueOf(this.getDirectUpperLimit()));
            this.getOddsRatioEffectSizeResults().setLowerLimit(Double.valueOf(this.getDirectLowerLimit()));
            this.setLogOddsRatioEffectSizeResults(new LogOddsRatioEffectSizeResults());
            this.getLogOddsRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getOddsRatioEffectSizeResults().getEffectSize())));
            this.getLogOddsRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.log(this.getOddsRatioEffectSizeResults().getUpperLimit())));
            this.getLogOddsRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.log(this.getOddsRatioEffectSizeResults().getLowerLimit())));
            NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
            double z = normalDistribution.inverseCumulativeProbability((1.0 - this.getInterval()) / 2.0);
            double logOddsSE = (this.getLogOddsRatioEffectSizeResults().getUpperLimit() - this.getLogOddsRatioEffectSizeResults().getLowerLimit()) / 2.0 / z;
            this.getLogOddsRatioEffectSizeResults().setVariance(Double.valueOf(Math.pow(logOddsSE, 2.0)));
            this.getLogOddsRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            this.getOddsRatioEffectSizeResults().setPValue(this.getLogOddsRatioEffectSizeResults().getPValue());
            this.getOddsRatioEffectSizeResults().setZValue(this.getLogOddsRatioEffectSizeResults().getZValue());
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public String getEffectSizeValueCategory() {
        return "Binary data";
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel");
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"binaryDirectEffectSizesCategory");
    }

    public String getName() {
        return NbBundle.getMessage(DirectESOddsRatio.class, (String)"DirectESOddsRatio.name");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logOddsRatioLabel");
    }
}

