/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.binary;

import java.io.Serializable;
import metaanalysis.effectsize.implementations.ADirectESFormat;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.RiskDifferenceEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DirectESRiskDifference
extends ADirectESFormat
implements IEffectSizeValue,
Serializable {
    public DirectESRiskDifference(double confidenceInterval, double directEffectSize, double directLowerLimit, double directUpperLimit, double interval, int sampleSize) {
        super(confidenceInterval, directEffectSize, directLowerLimit, directUpperLimit, interval, sampleSize);
    }

    public DirectESRiskDifference() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        try {
            this.setRiskDifferenceEffectSizeResults(new RiskDifferenceEffectSizeResults());
            this.getRiskDifferenceEffectSizeResults().setEffectSize(Double.valueOf(this.getDirectEffectSize()));
            this.getRiskDifferenceEffectSizeResults().setUpperLimit(Double.valueOf(this.getDirectUpperLimit()));
            this.getRiskDifferenceEffectSizeResults().setLowerLimit(Double.valueOf(this.getDirectLowerLimit()));
            NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
            double z = normalDistribution.inverseCumulativeProbability((1.0 - this.getInterval()) / 2.0);
            double se = (this.getRiskDifferenceEffectSizeResults().getUpperLimit() - this.getRiskDifferenceEffectSizeResults().getLowerLimit()) / 2.0 / z;
            this.getRiskDifferenceEffectSizeResults().setVariance(Double.valueOf(Math.pow(se, 2.0)));
            this.getRiskDifferenceEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"binaryCategory");
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"riskDifferenceLabel");
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"binaryDirectEffectSizesCategory");
    }

    public String getName() {
        return NbBundle.getMessage(DirectESRiskDifference.class, (String)"DirectESRiskDifference.name");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"riskDifferenceLabel");
    }
}

