/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.binary;

import java.io.Serializable;
import metaanalysis.effectsize.implementations.ADirectESFormat;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.LogRiskRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RiskRatioEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DirectESRiskRatio
extends ADirectESFormat
implements IEffectSizeValue,
Serializable {
    public DirectESRiskRatio(double confidenceInterval, double directEffectSize, double directLowerLimit, double directUpperLimit, double interval, int sampleSize) {
        super(confidenceInterval, directEffectSize, directLowerLimit, directUpperLimit, interval, sampleSize);
    }

    public DirectESRiskRatio() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        try {
            this.setRiskRatioEffectSizeResults(new RiskRatioEffectSizeResults());
            this.getRiskRatioEffectSizeResults().setEffectSize(Double.valueOf(this.getDirectEffectSize()));
            this.getRiskRatioEffectSizeResults().setUpperLimit(Double.valueOf(this.getDirectUpperLimit()));
            this.getRiskRatioEffectSizeResults().setLowerLimit(Double.valueOf(this.getDirectLowerLimit()));
            this.setLogRiskRatioEffectSizeResults(new LogRiskRatioEffectSizeResults());
            this.getLogRiskRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getRiskRatioEffectSizeResults().getEffectSize())));
            this.getLogRiskRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.log(this.getRiskRatioEffectSizeResults().getUpperLimit())));
            this.getLogRiskRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.log(this.getRiskRatioEffectSizeResults().getLowerLimit())));
            NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
            double z = normalDistribution.inverseCumulativeProbability((1.0 - this.getInterval()) / 2.0);
            double logRiskSE = (this.getLogRiskRatioEffectSizeResults().getUpperLimit() - this.getLogRiskRatioEffectSizeResults().getLowerLimit()) / 2.0 / z;
            this.getLogRiskRatioEffectSizeResults().setVariance(Double.valueOf(Math.pow(logRiskSE, 2.0)));
            this.getLogRiskRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            this.getRiskRatioEffectSizeResults().setPValue(this.getLogRiskRatioEffectSizeResults().getPValue());
            this.getRiskRatioEffectSizeResults().setZValue(this.getLogRiskRatioEffectSizeResults().getZValue());
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public String getEffectSizeValueCategory() {
        return "Binary data";
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel");
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"binaryDirectEffectSizesCategory");
    }

    public String getName() {
        return NbBundle.getMessage(DirectESRiskRatio.class, (String)"DirectESRiskRatio.name");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logRiskRatioLabel");
    }
}

