/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.correlations;

import java.io.Serializable;
import metaanalysis.effectsize.api.CorrelationSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.ACorrelationESFormat;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CorrelationEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.FishersZEffectSizeResults;
import org.openide.util.NbBundle;

public class Pearson_Correlation_SampleSize
extends ACorrelationESFormat
implements IEffectSizeValue,
Serializable {
    private Double correlation;
    private Integer sampleSize;

    public Pearson_Correlation_SampleSize(double confidenceInterval, int effectDirection, Double correlation, Integer sampleSize) {
        super(confidenceInterval, effectDirection, new CorrelationSampleSizeValueImpl(sampleSize));
        this.correlation = correlation;
        this.sampleSize = sampleSize;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel");
    }

    public Pearson_Correlation_SampleSize() {
    }

    public Double getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(Double correlation) {
        this.correlation = correlation;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setFishersZEffectSizeResults(new FishersZEffectSizeResults());
        this.getFishersZEffectSizeResults().setEffectSize(0.5 * Math.log((1.0 + this.correlation) / (1.0 - this.correlation)), this.effectDirection);
        this.getFishersZEffectSizeResults().setVariance(Double.valueOf(1.0 / (double)(this.sampleSize - 3)));
        this.getFishersZEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.setCorrelationEffectSizeResults(new CorrelationEffectSizeResults());
        this.getCorrelationEffectSizeResults().setEffectSize(this.correlation.doubleValue(), this.effectDirection);
        this.getCorrelationEffectSizeResults().setStandardError(Double.valueOf((1.0 - Math.pow(this.correlation, 2.0)) * this.getFishersZEffectSizeResults().getStandardError()));
        this.getCorrelationEffectSizeResults().setVariance(Double.valueOf(Math.pow(this.getCorrelationEffectSizeResults().getStandardError(), 2.0)));
        this.getCorrelationEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(Pearson_Correlation_SampleSize.class, (String)"Correlation_SampleSize");
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"pearsonsCorrelationsCategory");
    }
}

