/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.correlations;

import java.io.Serializable;
import metaanalysis.effectsize.api.CorrelationSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.ACorrelationESFormat;
import metaanalysis.effectsizes.models.ESRConversions;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CorrelationEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.FishersZEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Pearson_Correlation_pValue_tails
extends ACorrelationESFormat
implements IEffectSizeValue,
Serializable {
    private Double rawPValue;
    private Integer tails;
    private Integer sampleSize;

    public Pearson_Correlation_pValue_tails(double confidenceInterval, int effectDirection, Double rawPValue, int tails, Integer sampleSize) {
        super(confidenceInterval, effectDirection, new CorrelationSampleSizeValueImpl(sampleSize));
        this.rawPValue = rawPValue;
        this.tails = tails;
        this.sampleSize = sampleSize;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel");
    }

    public Pearson_Correlation_pValue_tails() {
    }

    public Double getRawPValue() {
        return this.rawPValue;
    }

    public void setRawPValue(Double rawPValue) {
        this.rawPValue = rawPValue;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public Integer getTails() {
        return this.tails;
    }

    public void setTails(Integer tails) {
        this.tails = tails;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        double df = this.getSampleSize() - 2;
        TDistributionImpl dist = new TDistributionImpl(df);
        try {
            double xxx = this.getRawPValue() / 2.0;
            if (this.tails == 1) {
                xxx = 1.0 - Math.abs(2.0 * xxx - 1.0);
            }
            double t = dist.inverseCumulativeProbability(xxx);
            this.setCorrelationEffectSizeResults(new CorrelationEffectSizeResults());
            double r = Math.sqrt(Math.pow(t, 2.0) / (Math.pow(t, 2.0) + df));
            this.getCorrelationEffectSizeResults().setEffectSize(r, this.effectDirection);
            this.setFishersZEffectSizeResults(new FishersZEffectSizeResults());
            this.getFishersZEffectSizeResults().setEffectSize(0.5 * Math.log((1.0 + r) / (1.0 - r)), this.effectDirection);
            double seZ = 1.0 / Math.sqrt(this.getSampleSize() - 3);
            this.getFishersZEffectSizeResults().setVariance(Double.valueOf(Math.pow(seZ, 2.0)));
            this.getFishersZEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            double seC = (1.0 - Math.pow(r, 2.0)) * seZ;
            this.getCorrelationEffectSizeResults().setVariance(Double.valueOf(Math.pow(seC, 2.0)));
            this.getCorrelationEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            this.getCorrelationEffectSizeResults().setZValue(this.getFishersZEffectSizeResults().getZValue());
            this.getCorrelationEffectSizeResults().setPValue(this.getFishersZEffectSizeResults().getPValue());
            this.getCorrelationEffectSizeResults().setLowerLimit(Double.valueOf(ESRConversions.simpleConversionFromFisherToR((double)this.getFishersZEffectSizeResults().getLowerLimit())));
            this.getCorrelationEffectSizeResults().setUpperLimit(Double.valueOf(ESRConversions.simpleConversionFromFisherToR((double)this.getFishersZEffectSizeResults().getUpperLimit())));
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(Pearson_Correlation_pValue_tails.class, (String)"p_value_tails_SampleSize");
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"pearsonsCorrelationsCategory");
    }
}

