/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AContinuousESFormat;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DirectESCohenD
extends AContinuousESFormat
implements IEffectSizeValue,
Serializable {
    private double directEffectSize;
    private double directLowerLimit;
    private double directUpperLimit;
    private double interval;

    public DirectESCohenD(double confidenceInterval, int effectDirection, double directEffectSize, double directLowerLimit, double directUpperLimit, double interval, int sampleSizeA, int sampleSizeB) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB), AContinuousESFormat.standardCorrelationValueForMeans);
        this.directEffectSize = directEffectSize;
        this.directLowerLimit = directLowerLimit;
        this.directUpperLimit = directUpperLimit;
        this.interval = interval;
    }

    public DirectESCohenD() {
    }

    public double getDirectEffectSize() {
        return this.directEffectSize;
    }

    public void setDirectEffectSize(double directEffectSize) {
        this.directEffectSize = directEffectSize;
    }

    public double getDirectLowerLimit() {
        return this.directLowerLimit;
    }

    public void setDirectLowerLimit(double directLowerLimit) {
        this.directLowerLimit = directLowerLimit;
    }

    public double getDirectUpperLimit() {
        return this.directUpperLimit;
    }

    public void setDirectUpperLimit(double directUpperLimit) {
        this.directUpperLimit = directUpperLimit;
    }

    public double getInterval() {
        return this.interval;
    }

    public void setInterval(double interval) {
        this.interval = interval;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        try {
            this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
            this.getCohensDEffectSizeResults().setEffectSize(this.getDirectEffectSize(), this.getEffectDirection());
            this.getCohensDEffectSizeResults().setUpperLimit(Double.valueOf(this.getDirectUpperLimit()));
            this.getCohensDEffectSizeResults().setLowerLimit(Double.valueOf(this.getDirectLowerLimit()));
            TDistributionImpl distribution = new TDistributionImpl((double)(this.getISampleSizeValue().getSampleSize() - 2));
            double z = distribution.inverseCumulativeProbability((1.0 - this.getInterval()) / 2.0);
            double se = (this.getCohensDEffectSizeResults().getUpperLimit() - this.getCohensDEffectSizeResults().getLowerLimit()) / 2.0 / z;
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(se, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"meanDirectEffectSizesCategory");
    }

    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"DirectESCohenD.name");
    }
}

