/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansIndipendentGroupsLongitudinalData;
import metaanalysis.effectsize.implementations.means.DirectESCohenD;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.openide.util.NbBundle;

public class ForEachGroupLongitudinal_Mean_F_SampleSize
extends AMeansIndipendentGroupsLongitudinalData
implements IEffectSizeValue,
Serializable {
    private Double meanPreA;
    private Double meanPostA;
    private Double meanPreB;
    private Double meanPostB;
    private Double effe;
    private int standardizeBy;

    public ForEachGroupLongitudinal_Mean_F_SampleSize(double confidenceInterval, int effectDirection, Double meanPreA, Double meanPostA, Integer sampleSizeA, Double meanPreB, Double meanPostB, Integer sampleSizeB, double effe, double correlation, int standardizeBy) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB), correlation);
        this.meanPreA = meanPreA;
        this.meanPostA = meanPostA;
        this.effe = effe;
        this.meanPreB = meanPreB;
        this.meanPostB = meanPostB;
        this.standardizeBy = standardizeBy;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public ForEachGroupLongitudinal_Mean_F_SampleSize() {
    }

    public Double getMeanPostA() {
        return this.meanPostA;
    }

    public void setMeanPostA(Double meanPostA) {
        this.meanPostA = meanPostA;
    }

    public Double getMeanPostB() {
        return this.meanPostB;
    }

    public void setMeanPostB(Double meanPostB) {
        this.meanPostB = meanPostB;
    }

    public Double getMeanPreA() {
        return this.meanPreA;
    }

    public void setMeanPreA(Double meanPreA) {
        this.meanPreA = meanPreA;
    }

    public Double getMeanPreB() {
        return this.meanPreB;
    }

    public void setMeanPreB(Double meanPreB) {
        this.meanPreB = meanPreB;
    }

    public Double getEffe() {
        return this.effe;
    }

    public void setEffe(Double effe) {
        this.effe = effe;
    }

    public int getStandardizeBy() {
        return this.standardizeBy;
    }

    public void setStandardizeBy(int standardizeBy) {
        this.standardizeBy = standardizeBy;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        double meanChange1 = 1.0 * this.meanPostA - this.meanPreA;
        double meanChange2 = 1.0 * this.meanPostB - this.meanPreB;
        double rawDiff = meanChange1 - meanChange2;
        if (this.standardizeBy == 0) {
            double sDPost = Math.sqrt((double)(this.getISampleSizeValue().getGroupASize() * this.getISampleSizeValue().getGroupBSize() / this.getISampleSizeValue().getSampleSize()) * Math.pow(rawDiff, 2.0) / (2.0 * (1.0 - this.getCorrelation()) * this.getEffe()));
            double stdPostDiff = rawDiff / sDPost;
            double stdPostDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdPostDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize()));
            this.getCohensDEffectSizeResults().setEffectSize(stdPostDiff, this.effectDirection);
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdPostDiffSE, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        } else {
            double stdChangeDiff = 1.0 * Math.sqrt(1.0 * this.effe * (1.0 * (double)this.getISampleSizeValue().getSampleSize() / (double)(this.getISampleSizeValue().getGroupASize() * this.getISampleSizeValue().getGroupBSize())));
            double sDChangePooled = rawDiff / stdChangeDiff;
            double stdChangeDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdChangeDiff, 2.0) / (double)(this.getISampleSizeValue().getSampleSize() - 2));
            this.getCohensDEffectSizeResults().setEffectSize(stdChangeDiff, this.effectDirection);
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdChangeDiffSE, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        double meanChange1 = this.meanPostA - this.meanPreA;
        double meanChange2 = this.meanPostB - this.meanPreB;
        double rawDiff = meanChange1 - meanChange2;
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(rawDiff, this.effectDirection);
        double StdChangeDiff = Math.sqrt(this.effe * (1.0 * (double)this.getISampleSizeValue().getSampleSize() / (1.0 * this.getISampleSizeValue().getEstimateGroupA() * this.getISampleSizeValue().getEstimateGroupB())));
        double SDChangePooled = rawDiff / StdChangeDiff;
        double MeanChangeDiffSE = Math.sqrt(1.0 / this.getISampleSizeValue().getEstimateGroupA() + 1.0 / this.getISampleSizeValue().getEstimateGroupB()) * SDChangePooled;
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(MeanChangeDiffSE, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"Mean_F_SampleSize_foreachgroup");
    }
}

