/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansIndipendentGroupsLongitudinalData;
import metaanalysis.effectsize.implementations.means.DirectESCohenD;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ForEachGroupLongitudinal_Mean_P_SampleSize
extends AMeansIndipendentGroupsLongitudinalData
implements IEffectSizeValue,
Serializable {
    private Double meanPreA;
    private Double meanPostA;
    private Double pValueA;
    private int tailsA;
    private Double meanPreB;
    private Double meanPostB;
    private Double pValueB;
    private int tailsB;
    private int standardizeBy;

    public ForEachGroupLongitudinal_Mean_P_SampleSize(double confidenceInterval, int effectDirection, Double meanPreA, Double meanPostA, Double pValueA, int tailsA, Integer sampleSizeA, Double meanPreB, Double meanPostB, Double pValueB, int tailsB, Integer sampleSizeB, double correlation, int standardizeBy) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB), correlation);
        this.meanPreA = meanPreA;
        this.pValueA = pValueA;
        this.meanPostA = meanPostA;
        this.pValueB = pValueB;
        this.meanPreB = meanPreB;
        this.meanPostB = meanPostB;
        this.standardizeBy = standardizeBy;
        this.tailsA = tailsA;
        this.tailsB = tailsB;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public ForEachGroupLongitudinal_Mean_P_SampleSize() {
    }

    public Double getMeanPostA() {
        return this.meanPostA;
    }

    public void setMeanPostA(Double meanPostA) {
        this.meanPostA = meanPostA;
    }

    public Double getMeanPostB() {
        return this.meanPostB;
    }

    public void setMeanPostB(Double meanPostB) {
        this.meanPostB = meanPostB;
    }

    public Double getMeanPreA() {
        return this.meanPreA;
    }

    public void setMeanPreA(Double meanPreA) {
        this.meanPreA = meanPreA;
    }

    public Double getMeanPreB() {
        return this.meanPreB;
    }

    public void setMeanPreB(Double meanPreB) {
        this.meanPreB = meanPreB;
    }

    public Double getPValueA() {
        return this.pValueA;
    }

    public void setPValueA(Double pValueA) {
        this.pValueA = pValueA;
    }

    public Double getPValueB() {
        return this.pValueB;
    }

    public void setPValueB(Double pValueB) {
        this.pValueB = pValueB;
    }

    public int getStandardizeBy() {
        return this.standardizeBy;
    }

    public void setStandardizeBy(int standardizeBy) {
        this.standardizeBy = standardizeBy;
    }

    public Double getpValueA() {
        return this.pValueA;
    }

    public void setpValueA(Double pValueA) {
        this.pValueA = pValueA;
    }

    public Double getpValueB() {
        return this.pValueB;
    }

    public void setpValueB(Double pValueB) {
        this.pValueB = pValueB;
    }

    public int getTailsA() {
        return this.tailsA;
    }

    public void setTailsA(int tailsA) {
        this.tailsA = tailsA;
    }

    public int getTailsB() {
        return this.tailsB;
    }

    public void setTailsB(int tailsB) {
        this.tailsB = tailsB;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        try {
            this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
            double meanChange1 = this.meanPostA - this.meanPreA;
            double meanChange2 = this.meanPostB - this.meanPreB;
            double rawDiff = meanChange1 - meanChange2;
            int dfA = this.iSampleSizeValue.getGroupASize() - 1;
            TDistributionImpl distA = new TDistributionImpl((double)dfA);
            double xxxA = 1.0 * this.getPValueA() / 2.0;
            if (this.tailsA == 1) {
                xxxA = 1.0 - Math.abs(2.0 * xxxA - 1.0);
            }
            double tA = distA.inverseCumulativeProbability(xxxA);
            int dfB = this.iSampleSizeValue.getGroupBSize() - 1;
            TDistributionImpl distB = new TDistributionImpl((double)dfB);
            double xxxB = 1.0 * this.getPValueB() / 2.0;
            if (this.tailsB == 1) {
                xxxB = 1.0 - Math.abs(2.0 * xxxB - 1.0);
            }
            double tB = distB.inverseCumulativeProbability(xxxB);
            if (this.standardizeBy == 0) {
                double sDPost1 = meanChange1 * Math.sqrt(this.getISampleSizeValue().getGroupASize()) / (tA * Math.sqrt(2.0 * (1.0 - this.getCorrelation())));
                double sDPost2 = meanChange2 * Math.sqrt(this.getISampleSizeValue().getGroupBSize()) / (tB * Math.sqrt(2.0 * (1.0 - this.getCorrelation())));
                double sDPostPooled = Math.sqrt(((double)(this.getISampleSizeValue().getGroupASize() - 1) * Math.pow(sDPost1, 2.0) + (double)(this.getISampleSizeValue().getGroupBSize() - 1) * Math.pow(sDPost2, 2.0)) / (double)(this.getISampleSizeValue().getSampleSize() - 2));
                double stdPostDiff = rawDiff / sDPostPooled;
                double stdPostDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdPostDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize()));
                this.getCohensDEffectSizeResults().setEffectSize(stdPostDiff, this.effectDirection);
                this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdPostDiffSE, 2.0)));
                this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            } else {
                double sDChange1 = 1.0 * Math.sqrt(this.getISampleSizeValue().getGroupASize()) * meanChange1 / tA;
                double sDChange2 = 1.0 * Math.sqrt(this.getISampleSizeValue().getGroupBSize()) * meanChange2 / tB;
                double sDChangePooled = Math.sqrt(((double)(this.getISampleSizeValue().getGroupASize() - 1) * Math.pow(sDChange1, 2.0) + (double)(this.getISampleSizeValue().getGroupBSize() - 1) * Math.pow(sDChange2, 2.0)) / (double)(this.getISampleSizeValue().getSampleSize() - 2));
                double stdChangeDiff = rawDiff / sDChangePooled;
                double stdChangeDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdChangeDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize()));
                this.getCohensDEffectSizeResults().setEffectSize(stdChangeDiff, this.effectDirection);
                this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdChangeDiffSE, 2.0)));
                this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            }
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        double meanChange1 = this.meanPostA - this.meanPreA;
        double meanChange2 = this.meanPostB - this.meanPreB;
        double rawDiff = meanChange1 - meanChange2;
        double PChange1 = 1.0 * this.getPValueA() / (1.0 * (double)this.getTailsA());
        double df1 = this.getISampleSizeValue().getEstimateGroupA() - 1.0;
        TDistributionImpl dist = new TDistributionImpl(df1);
        double xxx = 1.0 * this.getPValueA() / 2.0;
        if (this.tailsA == 1) {
            xxx = 1.0 - Math.abs(2.0 * xxx - 1.0);
        }
        double t1 = 0.0;
        try {
            t1 = dist.inverseCumulativeProbability(xxx);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        double TChange1 = Math.abs(t1);
        double SDChange1 = Math.sqrt(this.getISampleSizeValue().getEstimateGroupA()) * meanChange1 / TChange1;
        double PChange2 = 1.0 * this.getPValueB() / (1.0 * (double)this.getTailsB());
        double df2 = this.getISampleSizeValue().getEstimateGroupB() - 1.0;
        TDistributionImpl dist2 = new TDistributionImpl(df2);
        double xxx2 = 1.0 * this.getPValueB() / 2.0;
        if (this.tailsB == 1) {
            xxx2 = 1.0 - Math.abs(2.0 * xxx - 1.0);
        }
        double t2 = 0.0;
        try {
            t2 = dist2.inverseCumulativeProbability(xxx2);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        double TChange2 = Math.abs(t2);
        double SDChange2 = Math.sqrt(this.getISampleSizeValue().getEstimateGroupB()) * meanChange2 / TChange2;
        double sdChangePooled = Math.sqrt(((this.getISampleSizeValue().getEstimateGroupA() - 1.0) * Math.pow(SDChange1, 2.0) + (this.getISampleSizeValue().getEstimateGroupB() - 1.0) * Math.pow(SDChange2, 2.0)) / (1.0 * (double)this.getISampleSizeValue().getSampleSize() - 2.0));
        double stdError = Math.sqrt(1.0 / this.getISampleSizeValue().getEstimateGroupA() + 1.0 / this.getISampleSizeValue().getEstimateGroupB()) * sdChangePooled;
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(rawDiff, this.effectDirection);
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdError, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"Mean_pvalue_SampleSize_foreachgroup");
    }
}

