/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AContinuousESFormat;
import metaanalysis.effectsize.implementations.AMeansIndipendentGroupsLongitudinalData;
import metaanalysis.effectsize.implementations.means.DirectESCohenD;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.openide.util.NbBundle;

public class ForEachGroupLongitudinal_Mean_SD_SampleSize
extends AMeansIndipendentGroupsLongitudinalData
implements IEffectSizeValue,
Serializable {
    private Double meanPreA;
    private Double standardDeviationPreA;
    private Double meanPostA;
    private Double standardDeviationPostA;
    private Double meanPreB;
    private Double standardDeviationPreB;
    private Double meanPostB;
    private Double standardDeviationPostB;
    private int standardizeBy;

    public ForEachGroupLongitudinal_Mean_SD_SampleSize(double confidenceInterval, int effectDirection, Double meanPreA, Double standardDeviationPreA, Double meanPostA, Double standardDeviationPostA, Integer sampleSizeA, Double meanPreB, Double standardDeviationPreB, Double meanPostB, Double standardDeviationPostB, Integer sampleSizeB, double correlation, int standardizeBy) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB), correlation);
        this.meanPreA = meanPreA;
        this.standardDeviationPreA = standardDeviationPreA;
        this.meanPostA = meanPostA;
        this.standardDeviationPostA = standardDeviationPostA;
        this.meanPreB = meanPreB;
        this.standardDeviationPreB = standardDeviationPreB;
        this.meanPostB = meanPostB;
        this.standardDeviationPostB = standardDeviationPostB;
        this.standardizeBy = standardizeBy;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public ForEachGroupLongitudinal_Mean_SD_SampleSize() {
    }

    public Double getMeanPostA() {
        return this.meanPostA;
    }

    public void setMeanPostA(Double meanPostA) {
        this.meanPostA = meanPostA;
    }

    public Double getMeanPostB() {
        return this.meanPostB;
    }

    public void setMeanPostB(Double meanPostB) {
        this.meanPostB = meanPostB;
    }

    public Double getMeanPreA() {
        return this.meanPreA;
    }

    public void setMeanPreA(Double meanPreA) {
        this.meanPreA = meanPreA;
    }

    public Double getMeanPreB() {
        return this.meanPreB;
    }

    public void setMeanPreB(Double meanPreB) {
        this.meanPreB = meanPreB;
    }

    public Double getStandardDeviationPostA() {
        return this.standardDeviationPostA;
    }

    public void setStandardDeviationPostA(Double standardDeviationPostA) {
        this.standardDeviationPostA = standardDeviationPostA;
    }

    public Double getStandardDeviationPostB() {
        return this.standardDeviationPostB;
    }

    public void setStandardDeviationPostB(Double standardDeviationPostB) {
        this.standardDeviationPostB = standardDeviationPostB;
    }

    public Double getStandardDeviationPreA() {
        return this.standardDeviationPreA;
    }

    public void setStandardDeviationPreA(Double standardDeviationPreA) {
        this.standardDeviationPreA = standardDeviationPreA;
    }

    public Double getStandardDeviationPreB() {
        return this.standardDeviationPreB;
    }

    public void setStandardDeviationPreB(Double standardDeviationPreB) {
        this.standardDeviationPreB = standardDeviationPreB;
    }

    public int getStandardizeBy() {
        return this.standardizeBy;
    }

    public void setStandardizeBy(int standardizeBy) {
        this.standardizeBy = standardizeBy;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        double meanChange1 = this.meanPostA - this.meanPreA;
        double meanChange2 = this.meanPostB - this.meanPreB;
        double rawDiff = meanChange1 - meanChange2;
        if (this.standardizeBy == AContinuousESFormat.standardizedByPost_standard_deviation) {
            double sDPostPooled = Math.sqrt(((double)(this.getISampleSizeValue().getGroupASize() - 1) * Math.pow(this.getStandardDeviationPostA(), 2.0) + (double)(this.getISampleSizeValue().getGroupBSize() - 1) * Math.pow(this.getStandardDeviationPostB(), 2.0)) / (double)(this.getISampleSizeValue().getSampleSize() - 2));
            double stdPostDiff = rawDiff / sDPostPooled;
            double stdPostDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdPostDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize()));
            this.getCohensDEffectSizeResults().setEffectSize(stdPostDiff, this.effectDirection);
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdPostDiffSE, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        } else {
            double sDChange1 = Math.sqrt(Math.pow(this.standardDeviationPreA, 2.0) + Math.pow(this.standardDeviationPostA, 2.0) - 2.0 * this.getCorrelation() * this.standardDeviationPreA * this.standardDeviationPostA);
            double sDChange2 = Math.sqrt(Math.pow(this.standardDeviationPreB, 2.0) + Math.pow(this.standardDeviationPostB, 2.0) - 2.0 * this.getCorrelation() * this.standardDeviationPreB * this.standardDeviationPostB);
            double sDChangePooled = Math.sqrt(((double)(this.getISampleSizeValue().getGroupASize() - 1) * Math.pow(sDChange1, 2.0) + (double)(this.getISampleSizeValue().getGroupBSize() - 1) * Math.pow(sDChange2, 2.0)) / (double)(this.getISampleSizeValue().getSampleSize() - 2));
            double stdChangeDiff = rawDiff / sDChangePooled;
            double stdChangeDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdChangeDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize()));
            this.getCohensDEffectSizeResults().setEffectSize(stdChangeDiff, this.effectDirection);
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdChangeDiffSE, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        double meanChange1 = this.meanPostA - this.meanPreA;
        double meanChange2 = this.meanPostB - this.meanPreB;
        double rawDiff = meanChange1 - meanChange2;
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(rawDiff, this.effectDirection);
        double sdChange1 = Math.sqrt(Math.pow(this.standardDeviationPreA, 2.0) + Math.pow(this.standardDeviationPostA, 2.0) - 2.0 * (this.getCorrelation() * this.standardDeviationPreA * this.standardDeviationPostA));
        double sdChange2 = Math.sqrt(Math.pow(this.standardDeviationPreB, 2.0) + Math.pow(this.standardDeviationPostB, 2.0) - 2.0 * (this.getCorrelation() * this.standardDeviationPreB * this.standardDeviationPostB));
        double sdChangePooled = Math.sqrt(((this.getISampleSizeValue().getEstimateGroupA() - 1.0) * Math.pow(sdChange1, 2.0) + (this.getISampleSizeValue().getEstimateGroupB() - 1.0) * Math.pow(sdChange2, 2.0)) / (1.0 * (double)this.getISampleSizeValue().getSampleSize() - 2.0));
        double stdError = Math.sqrt(1.0 / this.getISampleSizeValue().getEstimateGroupA() + 1.0 / this.getISampleSizeValue().getEstimateGroupB()) * sdChangePooled;
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdError, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"Mean_SD_SampleSize_foreachgroup");
    }
}

