/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansIndipendentGroupsLongitudinalData;
import metaanalysis.effectsize.implementations.means.DirectESCohenD;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.openide.util.NbBundle;

public class ForEachGroupLongitudinal_Mean_T_SampleSize
extends AMeansIndipendentGroupsLongitudinalData
implements IEffectSizeValue,
Serializable {
    private Double meanPreA;
    private Double meanPostA;
    private Double tValueA;
    private Double meanPreB;
    private Double meanPostB;
    private Double tValueB;
    private int standardizeBy;

    public ForEachGroupLongitudinal_Mean_T_SampleSize(double confidenceInterval, int effectDirection, Double meanPreA, Double meanPostA, Double tValueA, Integer sampleSizeA, Double meanPreB, Double meanPostB, Double tValueB, Integer sampleSizeB, double correlation, int standardizeBy) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB), correlation);
        this.meanPreA = meanPreA;
        this.tValueA = tValueA;
        this.meanPostA = meanPostA;
        this.tValueB = tValueB;
        this.meanPreB = meanPreB;
        this.meanPostB = meanPostB;
        this.standardizeBy = standardizeBy;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public ForEachGroupLongitudinal_Mean_T_SampleSize() {
    }

    public Double getMeanPostA() {
        return this.meanPostA;
    }

    public void setMeanPostA(Double meanPostA) {
        this.meanPostA = meanPostA;
    }

    public Double getMeanPostB() {
        return this.meanPostB;
    }

    public void setMeanPostB(Double meanPostB) {
        this.meanPostB = meanPostB;
    }

    public Double getMeanPreA() {
        return this.meanPreA;
    }

    public void setMeanPreA(Double meanPreA) {
        this.meanPreA = meanPreA;
    }

    public Double getMeanPreB() {
        return this.meanPreB;
    }

    public void setMeanPreB(Double meanPreB) {
        this.meanPreB = meanPreB;
    }

    public Double getTValueA() {
        return this.tValueA;
    }

    public void setTValueA(Double tValueA) {
        this.tValueA = tValueA;
    }

    public Double getTValueB() {
        return this.tValueB;
    }

    public void setTValueB(Double tValueB) {
        this.tValueB = tValueB;
    }

    public int getStandardizeBy() {
        return this.standardizeBy;
    }

    public void setStandardizeBy(int standardizeBy) {
        this.standardizeBy = standardizeBy;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        double meanChange1 = this.meanPostA - this.meanPreA;
        double meanChange2 = this.meanPostB - this.meanPreB;
        double rawDiff = meanChange1 - meanChange2;
        if (this.standardizeBy == 0) {
            double sDPost1 = meanChange1 * Math.sqrt(this.getISampleSizeValue().getGroupASize()) / (this.tValueA * Math.sqrt(2.0 * (1.0 - this.getCorrelation())));
            double sDPost2 = meanChange2 * Math.sqrt(this.getISampleSizeValue().getGroupBSize()) / (this.tValueB * Math.sqrt(2.0 * (1.0 - this.getCorrelation())));
            double sDPostPooled = Math.sqrt(((double)(this.getISampleSizeValue().getGroupASize() - 1) * Math.pow(sDPost1, 2.0) + (double)(this.getISampleSizeValue().getGroupBSize() - 1) * Math.pow(sDPost2, 2.0)) / (double)(this.getISampleSizeValue().getSampleSize() - 2));
            double stdPostDiff = rawDiff / sDPostPooled;
            double stdPostDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdPostDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize()));
            this.getCohensDEffectSizeResults().setEffectSize(stdPostDiff, this.effectDirection);
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdPostDiffSE, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        } else {
            double sDChange1 = 1.0 * Math.sqrt(this.getISampleSizeValue().getGroupASize()) * meanChange1 / this.getTValueA();
            double sDChange2 = 1.0 * Math.sqrt(this.getISampleSizeValue().getGroupBSize()) * meanChange2 / this.getTValueB();
            double sDChangePooled = Math.sqrt(((double)(this.getISampleSizeValue().getGroupASize() - 1) * Math.pow(sDChange1, 2.0) + (double)(this.getISampleSizeValue().getGroupBSize() - 1) * Math.pow(sDChange2, 2.0)) / (double)(this.getISampleSizeValue().getSampleSize() - 2));
            double stdChangeDiff = rawDiff / sDChangePooled;
            double stdChangeDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getGroupASize() + 1.0 / (double)this.getISampleSizeValue().getGroupBSize() + Math.pow(stdChangeDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize()));
            this.getCohensDEffectSizeResults().setEffectSize(stdChangeDiff, this.effectDirection);
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdChangeDiffSE, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        double meanChange1 = this.meanPostA - this.meanPreA;
        double meanChange2 = this.meanPostB - this.meanPreB;
        double rawDiff = meanChange1 - meanChange2;
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(rawDiff, this.effectDirection);
        double sdChange1 = Math.sqrt(this.getISampleSizeValue().getEstimateGroupA()) * meanChange1 / this.getTValueA();
        double sdChange2 = Math.sqrt(this.getISampleSizeValue().getEstimateGroupB()) * meanChange2 / this.getTValueB();
        double sdChangePooled = Math.sqrt(((this.getISampleSizeValue().getEstimateGroupA() - 1.0) * Math.pow(sdChange1, 2.0) + (this.getISampleSizeValue().getEstimateGroupB() - 1.0) * Math.pow(sdChange2, 2.0)) / (1.0 * (double)this.getISampleSizeValue().getSampleSize() - 2.0));
        double stdError = Math.sqrt(1.0 / this.getISampleSizeValue().getEstimateGroupA() + 1.0 / this.getISampleSizeValue().getEstimateGroupB()) * sdChangePooled;
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdError, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"Mean_t_SampleSize_foreachgroup");
    }
}

