/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansIndipendentGroupsOneTime;
import metaanalysis.effectsize.implementations.means.DirectESCohenD;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.openide.util.NbBundle;

public class ForEachGroup_Mean_SD_SampleSize
extends AMeansIndipendentGroupsOneTime
implements IEffectSizeValue,
Serializable {
    private Double meanA;
    private Double standardDeviationA;
    private Integer sampleSizeA;
    private Double meanB;
    private Double standardDeviationB;
    private Integer sampleSizeB;

    public ForEachGroup_Mean_SD_SampleSize(double confidenceInterval, int effectDirection, Double meanA, Double standardDeviationA, Integer sampleSizeA, Double meanB, Double standardDeviationB, Integer sampleSizeB) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB));
        this.meanA = meanA;
        this.standardDeviationA = standardDeviationA;
        this.sampleSizeA = sampleSizeA;
        this.meanB = meanB;
        this.standardDeviationB = standardDeviationB;
        this.sampleSizeB = sampleSizeB;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public ForEachGroup_Mean_SD_SampleSize() {
    }

    public Double getMeanA() {
        return this.meanA;
    }

    public Double getMeanB() {
        return this.meanB;
    }

    public Integer getSampleSizeA() {
        return this.sampleSizeA;
    }

    public Integer getSampleSizeB() {
        return this.sampleSizeB;
    }

    public Double getStandardDeviationA() {
        return this.standardDeviationA;
    }

    public Double getStandardDeviationB() {
        return this.standardDeviationB;
    }

    public void setMeanA(Double meanA) {
        this.meanA = meanA;
    }

    public void setMeanB(Double meanB) {
        this.meanB = meanB;
    }

    public void setSampleSizeA(Integer sampleSizeA) {
        this.sampleSizeA = sampleSizeA;
    }

    public void setSampleSizeB(Integer sampleSizeB) {
        this.sampleSizeB = sampleSizeB;
    }

    public void setStandardDeviationA(Double standardDeviationA) {
        this.standardDeviationA = standardDeviationA;
    }

    public void setStandardDeviationB(Double standardDeviationB) {
        this.standardDeviationB = standardDeviationB;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        this.getCohensDEffectSizeResults().setEffectSize((this.meanA - this.meanB) / Math.sqrt(((double)(this.sampleSizeA - 1) * this.standardDeviationA * this.standardDeviationA + (double)(this.sampleSizeB - 1) * this.standardDeviationB * this.standardDeviationB) / (double)(this.sampleSizeA + this.sampleSizeB - 2)), this.effectDirection);
        this.getCohensDEffectSizeResults().setVariance(Double.valueOf(1.0 * (double)(this.sampleSizeA + this.sampleSizeB) / (double)(this.sampleSizeA * this.sampleSizeB) + this.getCohensDEffectSizeResults().getEffectSize() * this.getCohensDEffectSizeResults().getEffectSize() / (double)((this.sampleSizeA + this.sampleSizeB) * 2)));
        this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(Double.valueOf(this.meanA - this.meanB));
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(this.standardDeviationA, 2.0) / (double)this.sampleSizeA.intValue() + Math.pow(this.standardDeviationB, 2.0) / (double)this.sampleSizeB.intValue()));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"Mean_SD_SampleSize_foreachgroup");
    }
}

