/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.implementations.means.DirectESCohenD;
import metaanalysis.effectsize.implementations.means.ForEachGroup_SampleSize_PValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ForEachGroup_Mean_SampleSize_PValue
extends ForEachGroup_SampleSize_PValue
implements IEffectSizeValue,
Serializable {
    private Double meanA;
    private Double meanB;

    public ForEachGroup_Mean_SampleSize_PValue(double confidenceInterval, int effectDirection, Double meanA, Integer sampleSizeA, Double meanB, Integer sampleSizeB, Double pValue, int tails) {
        super(confidenceInterval, effectDirection, sampleSizeA, sampleSizeB, pValue, tails);
        this.meanA = meanA;
        this.meanB = meanB;
    }

    public ForEachGroup_Mean_SampleSize_PValue() {
    }

    public Double getMeanA() {
        return this.meanA;
    }

    public Double getMeanB() {
        return this.meanB;
    }

    public void setMeanA(Double meanA) {
        this.meanA = meanA;
    }

    public void setMeanB(Double meanB) {
        this.meanB = meanB;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        if (this.meanA > this.meanB) {
            this.calcola(1.0);
        } else {
            this.calcola(-1.0);
        }
        int df = this.iSampleSizeValue.getGroupASize() + this.iSampleSizeValue.getGroupBSize() - 2;
        double xxx = 1.0 * this.getpValue() / 2.0;
        if (this.getTails() == 1) {
            xxx = 1.0 - Math.abs(2.0 * xxx - 1.0);
        }
        TDistributionImpl dist = new TDistributionImpl((double)df);
        try {
            double t = dist.inverseCumulativeProbability(xxx);
            this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
            this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(Double.valueOf(this.meanA - this.meanB));
            this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(Math.abs((this.meanA - this.meanB) / t), 2.0)));
            this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"Mean_sampleSize_pvalue_foreachgroup");
    }
}

