/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansIndipendentGroupsOneTime;
import metaanalysis.effectsize.implementations.means.DirectESCohenD;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ForEachGroup_SampleSize_PValue
extends AMeansIndipendentGroupsOneTime
implements IEffectSizeValue,
Serializable {
    private Double pValue;
    private int tails;

    public ForEachGroup_SampleSize_PValue(double confidenceInterval, int effectDirection, Integer sampleSizeA, Integer sampleSizeB, Double tValue, int tails) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB));
        this.pValue = tValue;
        this.tails = tails;
    }

    public ForEachGroup_SampleSize_PValue() {
    }

    public int getTails() {
        return this.tails;
    }

    public void setTails(int tails) {
        this.tails = tails;
    }

    public Double getpValue() {
        return this.pValue;
    }

    public void setpValue(Double pValue) {
        this.pValue = pValue;
    }

    public Double getPValue() {
        return this.pValue;
    }

    public void setPValue(Double pValue) {
        this.pValue = pValue;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.calcola(1.0);
    }

    protected void calcola(double coeff) {
        int df = this.iSampleSizeValue.getGroupASize() + this.iSampleSizeValue.getGroupBSize() - 2;
        TDistributionImpl dist = new TDistributionImpl((double)df);
        try {
            double xxx = 1.0 * this.getpValue() / (double)this.tails;
            if (this.tails == 1) {
                xxx = 1.0 - Math.abs(2.0 * xxx - 1.0);
            }
            double distribuzioneT = dist.inverseCumulativeProbability(xxx);
            double tmp = distribuzioneT * Math.sqrt(1.0 * (double)this.getISampleSizeValue().getSampleSize() / (this.iSampleSizeValue.getEstimateGroupA() * this.iSampleSizeValue.getEstimateGroupB()));
            this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
            if (coeff > 0.0) {
                this.getCohensDEffectSizeResults().setEffectSize(Math.abs(tmp), this.effectDirection);
            } else {
                this.getCohensDEffectSizeResults().setEffectSize(-Math.abs(tmp), this.effectDirection);
            }
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(1.0 * (double)this.getISampleSizeValue().getSampleSize() / (this.iSampleSizeValue.getEstimateGroupA() * this.iSampleSizeValue.getEstimateGroupB()) + Math.pow(this.getCohensDEffectSizeResults().getEffectSize(), 2.0) / (double)(2 * this.getISampleSizeValue().getSampleSize())));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(DirectESCohenD.class, (String)"SampleSize_pvalue_foreachgroup");
    }
}

