/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansIndipendentGroupsOneTime;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import org.openide.util.NbBundle;

public class ForEachGroup_SampleSize_TValue
extends AMeansIndipendentGroupsOneTime
implements IEffectSizeValue,
Serializable {
    private Double tValue;
    private Integer sampleSizeA;
    private Integer sampleSizeB;

    public ForEachGroup_SampleSize_TValue(double confidenceInterval, int effectDirection, Integer sampleSizeA, Integer sampleSizeB, Double tValue) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSizeA, sampleSizeB));
        this.tValue = tValue;
        this.sampleSizeA = sampleSizeA;
        this.sampleSizeB = sampleSizeB;
    }

    public ForEachGroup_SampleSize_TValue() {
    }

    public Integer getSampleSizeA() {
        return this.sampleSizeA;
    }

    public Integer getSampleSizeB() {
        return this.sampleSizeB;
    }

    public void setSampleSizeA(Integer sampleSizeA) {
        this.sampleSizeA = sampleSizeA;
    }

    public void setSampleSizeB(Integer sampleSizeB) {
        this.sampleSizeB = sampleSizeB;
    }

    public Double gettValue() {
        return this.tValue;
    }

    public void settValue(Double tValue) {
        this.tValue = tValue;
    }

    public Double getTValue() {
        return this.tValue;
    }

    public void setTValue(Double tValue) {
        this.tValue = tValue;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.calcola(1.0);
    }

    protected void calcola(double coeff) {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        double harmonicN = 2.0 * this.getISampleSizeValue().getEstimateGroupA() * this.getISampleSizeValue().getEstimateGroupB() / (1.0 * this.getISampleSizeValue().getEstimateGroupA() + this.getISampleSizeValue().getEstimateGroupB());
        double stdDiff = coeff * this.tValue / (Math.sqrt(harmonicN) / Math.sqrt(2.0));
        double stdDiffSE = Math.sqrt(1.0 / this.getISampleSizeValue().getEstimateGroupA() + 1.0 / this.getISampleSizeValue().getEstimateGroupB() + Math.pow(stdDiff, 2.0) / (double)(2 * this.getISampleSizeValue().getSampleSize()));
        if (coeff > 0.0) {
            this.getCohensDEffectSizeResults().setEffectSize(Math.abs(stdDiff), this.effectDirection);
        } else {
            this.getCohensDEffectSizeResults().setEffectSize(-Math.abs(stdDiff), this.effectDirection);
        }
        this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdDiffSE, 2.0)));
        this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(ForEachGroup_SampleSize_TValue.class, (String)"SampleSize_tvalue_foreachgroup");
    }
}

