/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansOneGroupLongitudinalORMatchedgroupsData;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.openide.util.NbBundle;

public abstract class OGMG_MeanDiff_SDDiff_SampleSize
extends AMeansOneGroupLongitudinalORMatchedgroupsData
implements IEffectSizeValue,
Serializable {
    private Double meanDiff;
    private Double standardDeviationDiff;

    public OGMG_MeanDiff_SDDiff_SampleSize(double confidenceInterval, int effectDirection, Double meanDiff, Double standardDeviationDiff, Integer sampleSize, double correlation) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSize), correlation);
        this.meanDiff = meanDiff;
        this.standardDeviationDiff = standardDeviationDiff;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public OGMG_MeanDiff_SDDiff_SampleSize() {
    }

    public Double getMeanDiff() {
        return this.meanDiff;
    }

    public void setMeanDiff(Double meanDiff) {
        this.meanDiff = meanDiff;
    }

    public Double getStandardDeviationDiff() {
        return this.standardDeviationDiff;
    }

    public void setStandardDeviationDiff(Double standardDeviationDiff) {
        this.standardDeviationDiff = standardDeviationDiff;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        double pairedDiffSD = this.standardDeviationDiff / Math.sqrt(this.getISampleSizeValue().getSampleSize());
        double stdDiff = this.meanDiff / (this.standardDeviationDiff / Math.sqrt(2.0 * (1.0 - this.getCorrelation())));
        double stdDiffSe = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getSampleSize() + Math.pow(stdDiff, 2.0) / (double)(2 * this.getISampleSizeValue().getSampleSize())) * Math.sqrt(2.0 * (1.0 - this.getCorrelation()));
        this.getCohensDEffectSizeResults().setEffectSize(stdDiff, this.effectDirection);
        this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdDiffSe, 2.0)));
        this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(this.meanDiff.doubleValue(), this.effectDirection);
        double serror = this.standardDeviationDiff / Math.sqrt(this.getISampleSizeValue().getSampleSize());
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(serror, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(OGMG_MeanDiff_SDDiff_SampleSize.class, (String)"Mean_difference_SD_difference_ogmg");
    }
}

