/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.implementations.means.OneGroup_Longitudinal_P_SampleSize;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OGMG_Mean_P_SampleSize
extends OneGroup_Longitudinal_P_SampleSize
implements IEffectSizeValue,
Serializable {
    private Double meanPre;
    private Double meanPost;

    public OGMG_Mean_P_SampleSize(double confidenceInterval, int effectDirection, Double meanPre, Double meanPost, Integer sampleSize, double pValue, int tails, double correlation) {
        super(confidenceInterval, effectDirection, sampleSize, pValue, tails, correlation);
        this.meanPre = meanPre;
        this.meanPost = meanPost;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public OGMG_Mean_P_SampleSize() {
    }

    public Double getMeanPost() {
        return this.meanPost;
    }

    public void setMeanPost(Double meanPost) {
        this.meanPost = meanPost;
    }

    public Double getMeanPre() {
        return this.meanPre;
    }

    public void setMeanPre(Double meanPre) {
        this.meanPre = meanPre;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        if (this.meanPost > this.meanPre) {
            this.calcola(1.0);
        } else {
            this.calcola(-1.0);
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(OneGroup_Longitudinal_P_SampleSize.class, (String)"Mean_SampleSize_p_value_ogmg");
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(this.meanPost - this.meanPre, this.effectDirection);
        TDistributionImpl dist = new TDistributionImpl((double)(this.getISampleSizeValue().getSampleSize() - 1));
        double xxx = 1.0 * this.getPValue() / 2.0;
        if (this.getTails() == 1) {
            xxx = 1.0 - Math.abs(2.0 * xxx - 1.0);
        }
        double t1 = 0.0;
        try {
            t1 = dist.inverseCumulativeProbability(xxx);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        double serror = Math.abs(this.getRowDifferenceInMeansEffectSizeResults().getEffectSize() / t1);
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(serror, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }
}

