/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansOneGroupLongitudinalORMatchedgroupsData;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.openide.util.NbBundle;

public abstract class OGMG_Mean_SD_SampleSize
extends AMeansOneGroupLongitudinalORMatchedgroupsData
implements IEffectSizeValue,
Serializable {
    private Double meanPre;
    private Double standardDeviationPre;
    private Double meanPost;
    private Double standardDeviationPost;

    public OGMG_Mean_SD_SampleSize(double confidenceInterval, int effectDirection, Double meanPre, Double standardDeviationPre, Double meanPost, Double standardDeviationPost, Integer sampleSize, double correlation) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSize), correlation);
        this.meanPre = meanPre;
        this.standardDeviationPre = standardDeviationPre;
        this.meanPost = meanPost;
        this.standardDeviationPost = standardDeviationPost;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public OGMG_Mean_SD_SampleSize() {
    }

    public Double getMeanPost() {
        return this.meanPost;
    }

    public void setMeanPost(Double meanPost) {
        this.meanPost = meanPost;
    }

    public Double getMeanPre() {
        return this.meanPre;
    }

    public void setMeanPre(Double meanPre) {
        this.meanPre = meanPre;
    }

    public Double getStandardDeviationPost() {
        return this.standardDeviationPost;
    }

    public void setStandardDeviationPost(Double standardDeviationPost) {
        this.standardDeviationPost = standardDeviationPost;
    }

    public Double getStandardDeviationPre() {
        return this.standardDeviationPre;
    }

    public void setStandardDeviationPre(Double standardDeviationPre) {
        this.standardDeviationPre = standardDeviationPre;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        double pairedDiff = this.meanPost - this.meanPre;
        double pairedDiffSD = Math.sqrt(Math.pow(this.standardDeviationPre, 2.0) + Math.pow(this.standardDeviationPost, 2.0) - 2.0 * this.getCorrelation() * this.standardDeviationPre * this.standardDeviationPost);
        double pairedDiffSE = pairedDiff / Math.sqrt(this.getISampleSizeValue().getSampleSize());
        double stdDiff = pairedDiff / (pairedDiffSD / Math.sqrt(2.0 * (1.0 - this.getCorrelation())));
        double stdDiffSe = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getSampleSize() + Math.pow(stdDiff, 2.0) / (double)(2 * this.getISampleSizeValue().getSampleSize())) * Math.sqrt(2.0 * (1.0 - this.getCorrelation()));
        this.getCohensDEffectSizeResults().setEffectSize(stdDiff, this.effectDirection);
        this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdDiffSe, 2.0)));
        this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(this.meanPost - this.meanPre, this.effectDirection);
        double sdDiff = Math.sqrt(Math.pow(this.standardDeviationPre, 2.0) + Math.pow(this.standardDeviationPost, 2.0) - 2.0 * this.getCorrelation() * this.getStandardDeviationPre() * this.getStandardDeviationPost());
        double serror = sdDiff / Math.sqrt(this.getISampleSizeValue().getSampleSize());
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(serror, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(OGMG_Mean_SD_SampleSize.class, (String)"Mean_SD_SampleSize_ogmg");
    }
}

