/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.implementations.means.OGMG_T_SampleSize;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.RowDifferenceInMeansEffectSizeResults;
import org.openide.util.NbBundle;

public abstract class OGMG_Mean_T_SampleSize
extends OGMG_T_SampleSize
implements IEffectSizeValue,
Serializable {
    private Double meanPre;
    private Double meanPost;

    public OGMG_Mean_T_SampleSize(double confidenceInterval, int effectDirection, Double meanPre, Double meanPost, Integer sampleSize, double tValue, double correlation) {
        super(confidenceInterval, effectDirection, sampleSize, tValue, correlation);
        this.meanPre = meanPre;
        this.meanPost = meanPost;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public OGMG_Mean_T_SampleSize() {
    }

    public Double getMeanPost() {
        return this.meanPost;
    }

    public void setMeanPost(Double meanPost) {
        this.meanPost = meanPost;
    }

    public Double getMeanPre() {
        return this.meanPre;
    }

    public void setMeanPre(Double meanPre) {
        this.meanPre = meanPre;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        if (this.meanPost > this.meanPre) {
            this.calcola(1.0);
        } else {
            this.calcola(-1.0);
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(OGMG_Mean_T_SampleSize.class, (String)"Mean_T_SampleSize_ogmg");
    }

    @Override
    protected void fillAllConversions() {
        super.fillAllConversions();
        this.setRowDifferenceInMeansEffectSizeResults(new RowDifferenceInMeansEffectSizeResults());
        this.getRowDifferenceInMeansEffectSizeResults().setEffectSize(this.meanPost - this.meanPre, this.effectDirection);
        double serror = Math.abs(this.getRowDifferenceInMeansEffectSizeResults().getEffectSize() / this.getTValue());
        this.getRowDifferenceInMeansEffectSizeResults().setVariance(Double.valueOf(Math.pow(serror, 2.0)));
        this.getRowDifferenceInMeansEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }
}

