/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansOneGroupLongitudinalORMatchedgroupsData;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class OGMG_P_SampleSize
extends AMeansOneGroupLongitudinalORMatchedgroupsData
implements IEffectSizeValue,
Serializable {
    private double pValue;
    private int tails;

    public OGMG_P_SampleSize(double confidenceInterval, int effectDirection, Integer sampleSize, double pValue, int tails, double correlation) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSize), correlation);
        this.pValue = pValue;
        this.tails = tails;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public OGMG_P_SampleSize() {
    }

    public double getpValue() {
        return this.pValue;
    }

    public void setpValue(double pValue) {
        this.pValue = pValue;
    }

    public double getPValue() {
        return this.pValue;
    }

    public void setPValue(double pValue) {
        this.pValue = pValue;
    }

    public int getTails() {
        return this.tails;
    }

    public void setTails(int tails) {
        this.tails = tails;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.calcola(1.0);
    }

    protected void calcola(double coef) {
        try {
            this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
            int df = this.iSampleSizeValue.getSampleSize() - 1;
            TDistributionImpl dist = new TDistributionImpl((double)df);
            double xxx = 1.0 * this.getPValue() / 2.0;
            if (this.tails == 1) {
                xxx = 1.0 - Math.abs(2.0 * xxx - 1.0);
            }
            double t = dist.inverseCumulativeProbability(xxx);
            double stdPairedDiff = t / Math.sqrt(this.getISampleSizeValue().getSampleSize());
            double stdPairedDiffSE = 1.0 / Math.sqrt(this.getISampleSizeValue().getSampleSize()) * Math.sqrt(1.0 + Math.pow(stdPairedDiff, 2.0) / 2.0);
            double stdDiff = stdPairedDiff * Math.sqrt(2.0 * (1.0 - this.getCorrelation()));
            double stdDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getSampleSize() + Math.pow(stdPairedDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize())) * Math.sqrt(2.0 * (1.0 - this.getCorrelation()));
            if (coef > 0.0) {
                this.getCohensDEffectSizeResults().setEffectSize(Math.abs(stdDiff), this.effectDirection);
            } else {
                this.getCohensDEffectSizeResults().setEffectSize(-Math.abs(stdDiff), this.effectDirection);
            }
            this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdDiffSE, 2.0)));
            this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(OGMG_P_SampleSize.class, (String)"SampleSize_pvalue_ogmg");
    }
}

