/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.means;

import java.io.Serializable;
import metaanalysis.effectsize.api.MeanSampleSizeValueImpl;
import metaanalysis.effectsize.implementations.AMeansOneGroupLongitudinalORMatchedgroupsData;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import org.openide.util.NbBundle;

public abstract class OGMG_T_SampleSize
extends AMeansOneGroupLongitudinalORMatchedgroupsData
implements IEffectSizeValue,
Serializable {
    private double tValue;

    public OGMG_T_SampleSize(double confidenceInterval, int effectDirection, Integer sampleSize, double tValue, double correlation) {
        super(confidenceInterval, effectDirection, new MeanSampleSizeValueImpl(sampleSize), correlation);
        this.tValue = tValue;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel");
    }

    public OGMG_T_SampleSize() {
    }

    public double gettValue() {
        return this.tValue;
    }

    public void settValue(double tValue) {
        this.tValue = tValue;
    }

    public double getTValue() {
        return this.tValue;
    }

    public void setTValue(double tValue) {
        this.tValue = tValue;
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.calcola(1.0);
    }

    protected void calcola(double coef) {
        this.setCohensDEffectSizeResults(new CohensDEffectSizeResults());
        double stdPairedDiff = 1.0 * this.tValue / Math.sqrt(this.getISampleSizeValue().getSampleSize());
        double stdPairedDiffSE = 1.0 / Math.sqrt(this.getISampleSizeValue().getSampleSize()) * Math.sqrt(1.0 + Math.pow(stdPairedDiff, 2.0) / 2.0);
        double stdDiff = stdPairedDiff * Math.sqrt(2.0 * (1.0 - this.getCorrelation()));
        double stdDiffSE = Math.sqrt(1.0 / (double)this.getISampleSizeValue().getSampleSize() + Math.pow(stdPairedDiff, 2.0) / (2.0 * (double)this.getISampleSizeValue().getSampleSize())) * Math.sqrt(2.0 * (1.0 - this.getCorrelation()));
        if (coef > 0.0) {
            this.getCohensDEffectSizeResults().setEffectSize(Math.abs(stdDiff), this.effectDirection);
        } else {
            this.getCohensDEffectSizeResults().setEffectSize(-Math.abs(stdDiff), this.effectDirection);
        }
        this.getCohensDEffectSizeResults().setVariance(Double.valueOf(Math.pow(stdDiffSE, 2.0)));
        this.getCohensDEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(OGMG_T_SampleSize.class, (String)"SampleSize_tvalue_ogmg");
    }
}

