/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.onegroupsummary;

import java.io.Serializable;
import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsizes.models.GenericSampleSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.OneGroupSummaryEventRateEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.OneGroupSummaryLogEventRateEffectSizeResults;
import org.openide.util.NbBundle;

public abstract class AbstractOneGroupSummary_Binary_Events
extends AbstractEffectSizeValue
implements IEffectSizeValue,
Serializable {
    protected int events;
    protected int notEvents;

    public AbstractOneGroupSummary_Binary_Events(int events, int notEvents, int sampleSize, double confidenceInterval) {
        super(confidenceInterval, 1, (ISampleSizeValue)new GenericSampleSizeValue(sampleSize, 0, 0, sampleSize, 0.0, 0.0));
        this.events = events;
        this.notEvents = notEvents;
    }

    public AbstractOneGroupSummary_Binary_Events() {
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate");
    }

    @Override
    protected void fillAllConversions() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setOneGroupSummaryEventRateEffectSizeResults(new OneGroupSummaryEventRateEffectSizeResults());
        this.setOneGroupSummaryLogEventRateEffectSizeResults(new OneGroupSummaryLogEventRateEffectSizeResults());
        double eventi = this.getEvents();
        double campione = this.getISampleSizeValue().getSampleSize();
        if (eventi == 0.0) {
            eventi += 0.5;
            campione += 1.0;
        }
        double xxx = 1.0 * eventi / (campione * 1.0);
        this.getOneGroupSummaryLogEventRateEffectSizeResults().setEffectSize(Double.valueOf(Math.log(xxx / (1.0 - xxx))));
        this.getOneGroupSummaryLogEventRateEffectSizeResults().setVariance(Double.valueOf(1.0 / (xxx * campione) + 1.0 / ((1.0 - xxx) * campione)));
        this.getOneGroupSummaryLogEventRateEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.getOneGroupSummaryEventRateEffectSizeResults().setEffectSize(Double.valueOf(Math.exp(this.getOneGroupSummaryLogEventRateEffectSizeResults().getEffectSize()) / (Math.exp(this.getOneGroupSummaryLogEventRateEffectSizeResults().getEffectSize()) + 1.0)));
        this.getOneGroupSummaryEventRateEffectSizeResults().setLowerLimit(Double.valueOf(Math.exp(this.getOneGroupSummaryLogEventRateEffectSizeResults().getLowerLimit()) / (Math.exp(this.getOneGroupSummaryLogEventRateEffectSizeResults().getLowerLimit()) + 1.0)));
        this.getOneGroupSummaryEventRateEffectSizeResults().setUpperLimit(Double.valueOf(Math.exp(this.getOneGroupSummaryLogEventRateEffectSizeResults().getUpperLimit()) / (Math.exp(this.getOneGroupSummaryLogEventRateEffectSizeResults().getUpperLimit()) + 1.0)));
        this.getOneGroupSummaryEventRateEffectSizeResults().setPValue(this.getOneGroupSummaryLogEventRateEffectSizeResults().getPValue());
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"binaryCategory");
    }

    public String getEffectSizeValueSubCategory() {
        return "";
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.logEventRate");
    }

    public int getEvents() {
        return this.events;
    }

    public int getNotEvents() {
        return this.notEvents;
    }

    public void setEvents(int events) {
        this.events = events;
    }

    public void setNotEvents(int notEvents) {
        this.notEvents = notEvents;
    }

    public String toString() {
        return "Ev: " + this.getEvents() + "   N.Ev:" + this.getNotEvents() + "   SS:" + this.getISampleSizeValue().getSampleSize();
    }
}

