/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.onegroupsummary;

import java.io.Serializable;
import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsizes.models.GenericSampleSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.OneGroupSummaryRateEffectSizeResults;
import org.openide.util.NbBundle;

public class OneGroupSummary_IncidenceRate_EventRate_PersonsYear
extends AbstractEffectSizeValue
implements IEffectSizeValue,
Serializable {
    private double eventRate;
    private int persons;

    public OneGroupSummary_IncidenceRate_EventRate_PersonsYear() {
    }

    public OneGroupSummary_IncidenceRate_EventRate_PersonsYear(double eventRate, int persons, double confidenceInterval) {
        super(confidenceInterval, 1, (ISampleSizeValue)new GenericSampleSizeValue());
        this.eventRate = eventRate;
        this.persons = persons;
    }

    public double getEventRate() {
        return this.eventRate;
    }

    public void setEventRate(double eventRate) {
        this.eventRate = eventRate;
    }

    public int getPersons() {
        return this.persons;
    }

    public void setPersons(int persons) {
        this.persons = persons;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.rate");
    }

    @Override
    protected void fillAllConversions() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setOneGroupSummaryRateEffectSizeResults(new OneGroupSummaryRateEffectSizeResults());
        double rate = this.getEventRate();
        double personY = this.getPersons();
        if (rate == 0.0 || personY == 0.0) {
            this.getOneGroupSummaryRateEffectSizeResults().setEffectSize(Double.valueOf((rate += 0.5) / (personY += 0.5)));
            this.getOneGroupSummaryRateEffectSizeResults().setVariance(Double.valueOf(Math.pow(Math.sqrt(rate) / (1.0 * personY), 2.0)));
        } else {
            this.getOneGroupSummaryRateEffectSizeResults().setEffectSize(Double.valueOf(rate));
            this.getOneGroupSummaryRateEffectSizeResults().setVariance(Double.valueOf(Math.pow(Math.sqrt(personY * rate) / (1.0 * personY), 2.0)));
        }
        this.getOneGroupSummaryRateEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"singleGroupSummary.incidenceRatesCategory");
    }

    public String getEffectSizeValueSubCategory() {
        return "";
    }

    public String getName() {
        return NbBundle.getMessage(OneGroupSummary_IncidenceRate_EventRate_PersonsYear.class, (String)"OneGroupSummary_IncidenceRate_EventRate_PersonsYear.name");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.rate");
    }
}

