/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.onegroupsummary;

import java.io.Serializable;
import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsizes.models.GenericSampleSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.OneGroupSummaryRateEffectSizeResults;
import org.openide.util.NbBundle;

public class OneGroupSummary_IncidenceRate_Events_PersonsYear
extends AbstractEffectSizeValue
implements IEffectSizeValue,
Serializable {
    private int event;
    private int persons;

    public OneGroupSummary_IncidenceRate_Events_PersonsYear() {
    }

    public OneGroupSummary_IncidenceRate_Events_PersonsYear(int event, int persons, double confidenceInterval) {
        super(confidenceInterval, 1, (ISampleSizeValue)new GenericSampleSizeValue());
        this.event = event;
        this.persons = persons;
    }

    public int getEvent() {
        return this.event;
    }

    public void setEvent(int event) {
        this.event = event;
    }

    public int getPersons() {
        return this.persons;
    }

    public void setPersons(int persons) {
        this.persons = persons;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.rate");
    }

    @Override
    protected void fillAllConversions() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setOneGroupSummaryRateEffectSizeResults(new OneGroupSummaryRateEffectSizeResults());
        double eventCorretto = this.getEvent();
        double persons = this.getPersons();
        if (eventCorretto == 0.0 || persons == 0.0) {
            eventCorretto += 0.5;
            persons += 0.5;
        }
        this.getOneGroupSummaryRateEffectSizeResults().setEffectSize(Double.valueOf(1.0 * eventCorretto / (1.0 * persons)));
        this.getOneGroupSummaryRateEffectSizeResults().setVariance(Double.valueOf(Math.pow(Math.sqrt(eventCorretto) / (1.0 * persons), 2.0)));
        this.getOneGroupSummaryRateEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"singleGroupSummary.incidenceRatesCategory");
    }

    public String getEffectSizeValueSubCategory() {
        return "";
    }

    public String getName() {
        return NbBundle.getMessage(OneGroupSummary_IncidenceRate_Events_PersonsYear.class, (String)"OneGroupSummary_IncidenceRate_Events_PersonsYear.name");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.rate");
    }
}

