/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.onegroupsummary;

import java.io.Serializable;
import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsizes.models.GenericSampleSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.OneGroupSummaryMeanEffectSizeResults;
import org.openide.util.NbBundle;

public class OneGroupSummary_Mean_SD_SampleSize
extends AbstractEffectSizeValue
implements IEffectSizeValue,
Serializable {
    private double mean;
    private double standardDeviation;

    public OneGroupSummary_Mean_SD_SampleSize(double mean, double standardDeviation, int sampleSize, double confidenceInterval) {
        super(confidenceInterval, 1, (ISampleSizeValue)new GenericSampleSizeValue(sampleSize, 0, 0, sampleSize, 0.0, 0.0));
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    public OneGroupSummary_Mean_SD_SampleSize() {
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.mean");
    }

    @Override
    protected void fillAllConversions() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        this.setOneGroupSummaryMeanEffectSizeResults(new OneGroupSummaryMeanEffectSizeResults());
        this.getOneGroupSummaryMeanEffectSizeResults().setEffectSize(Double.valueOf(this.getMean()));
        this.getOneGroupSummaryMeanEffectSizeResults().setVariance(Double.valueOf(Math.pow(this.getStandardDeviation() * Math.sqrt(1.0 / (double)this.getISampleSizeValue().getSampleSize()), 2.0)));
        this.getOneGroupSummaryMeanEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    public String getName() {
        return NbBundle.getMessage(OneGroupSummary_Mean_SD_SampleSize.class, (String)"OneGroupSummary_Mean_SD_SampleSize.name");
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"meanCategory");
    }

    public String getEffectSizeValueSubCategory() {
        return "";
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.mean");
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }
}

