/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.rates;

import java.io.Serializable;
import metaanalysis.effectsize.implementations.ADirectESFormat;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.LogRateRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RateRatioEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DirectESRateRatio
extends ADirectESFormat
implements IEffectSizeValue,
Serializable {
    public DirectESRateRatio(double confidenceInterval, double directEffectSize, double directLowerLimit, double directUpperLimit, double interval, int sampleSize) {
        super(confidenceInterval, directEffectSize, directLowerLimit, directUpperLimit, interval, sampleSize);
    }

    public DirectESRateRatio() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        try {
            this.setRateRatioEffectSizeResults(new RateRatioEffectSizeResults());
            this.setLogRateRatioEffectSizeResults(new LogRateRatioEffectSizeResults());
            this.getRateRatioEffectSizeResults().setEffectSize(Double.valueOf(this.getDirectEffectSize()));
            this.getLogRateRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getDirectEffectSize())));
            this.getLogRateRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.log(this.getDirectUpperLimit())));
            this.getLogRateRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.log(this.getDirectLowerLimit())));
            NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
            double z = normalDistribution.inverseCumulativeProbability((1.0 - this.getInterval()) / 2.0);
            double se = (this.getLogRateRatioEffectSizeResults().getUpperLimit() - this.getLogRateRatioEffectSizeResults().getLowerLimit()) / 2.0 / z;
            this.getLogRateRatioEffectSizeResults().setVariance(Double.valueOf(Math.pow(se, 2.0)));
            this.getLogRateRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            this.getRateRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.exp(this.getLogRateRatioEffectSizeResults().getUpperLimit())));
            this.getRateRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.exp(this.getLogRateRatioEffectSizeResults().getLowerLimit())));
            this.getRateRatioEffectSizeResults().setPValue(this.getLogRateRatioEffectSizeResults().getPValue());
            this.getRateRatioEffectSizeResults().setZValue(this.getLogRateRatioEffectSizeResults().getZValue());
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"ratesCategory");
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel");
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"ratesDirectEffectSizesCategory");
    }

    public String getName() {
        return NbBundle.getMessage(DirectESRateRatio.class, (String)"DirectESRateRatio.name");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logRateRatioLabel");
    }
}

