/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.rates;

import java.io.Serializable;
import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsizes.models.GenericSampleSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.LogRateRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RateDifferenceEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.RateRatioEffectSizeResults;
import org.openide.util.NbBundle;

public class RatesIndipendentGroups_Events_PersonsYear
extends AbstractEffectSizeValue
implements IEffectSizeValue,
Serializable {
    private int eventA;
    private int personsA;
    private int eventB;
    private int personsB;

    public RatesIndipendentGroups_Events_PersonsYear() {
    }

    public RatesIndipendentGroups_Events_PersonsYear(double confidenceInterval, int eventA, int personsA, int eventB, int personsB) {
        super(confidenceInterval, 1, (ISampleSizeValue)new GenericSampleSizeValue());
        this.eventA = eventA;
        this.personsA = personsA;
        this.eventB = eventB;
        this.personsB = personsB;
    }

    public int getEventA() {
        return this.eventA;
    }

    public void setEventA(int eventA) {
        this.eventA = eventA;
    }

    public int getEventB() {
        return this.eventB;
    }

    public void setEventB(int eventB) {
        this.eventB = eventB;
    }

    public int getPersonsA() {
        return this.personsA;
    }

    public void setPersonsA(int personsA) {
        this.personsA = personsA;
    }

    public int getPersonsB() {
        return this.personsB;
    }

    public void setPersonsB(int personsB) {
        this.personsB = personsB;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel");
    }

    @Override
    protected void fillAllConversions() {
        this.setRateDifferenceEffectSizeResults(new RateDifferenceEffectSizeResults());
        double adder = 0.0;
        if (this.eventA == 0 || this.eventB == 0) {
            adder = 0.5;
        }
        double e1 = (double)this.eventA + adder;
        double e2 = (double)this.eventB + adder;
        double L1 = 1.0 * e1 / (1.0 * (double)this.personsA);
        double L2 = 1.0 * e2 / (1.0 * (double)this.personsB);
        double D = L1 - L2;
        double Vd = 1.0 * e1 / Math.pow(1.0 * (double)this.personsA, 2.0) + 1.0 * e2 / Math.pow(1.0 * (double)this.personsB, 2.0);
        this.getRateDifferenceEffectSizeResults().setEffectSize(Double.valueOf(D));
        this.getRateDifferenceEffectSizeResults().setVariance(Double.valueOf(Vd));
        this.getRateDifferenceEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
    }

    @Override
    protected void elaborateOwnEffectSize() {
        double a = this.eventA;
        double b = this.eventB;
        double rate1 = 1.0 * a / (double)this.personsA;
        double rate2 = 1.0 * b / (double)this.personsB;
        if (rate1 == 0.0 || rate2 == 0.0) {
            rate1 = 1.0 * (a += 0.5) / (double)this.personsA;
            rate2 = 1.0 * (b += 0.5) / (double)this.personsB;
        }
        this.setRateRatioEffectSizeResults(new RateRatioEffectSizeResults());
        this.setLogRateRatioEffectSizeResults(new LogRateRatioEffectSizeResults());
        this.getRateRatioEffectSizeResults().setEffectSize(Double.valueOf(rate1 / rate2));
        this.getLogRateRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getRateRatioEffectSizeResults().getEffectSize())));
        double logRateSE = Math.sqrt(1.0 / a + 1.0 / b);
        this.getLogRateRatioEffectSizeResults().setVariance(Double.valueOf(Math.pow(logRateSE, 2.0)));
        this.getLogRateRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
        this.getRateRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.exp(this.getLogRateRatioEffectSizeResults().getUpperLimit())));
        this.getRateRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.exp(this.getLogRateRatioEffectSizeResults().getLowerLimit())));
        this.getRateRatioEffectSizeResults().setPValue(this.getLogRateRatioEffectSizeResults().getPValue());
        this.getRateRatioEffectSizeResults().setZValue(this.getLogRateRatioEffectSizeResults().getZValue());
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"ratesCategory");
    }

    public String getEffectSizeValueSubCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"ratesIndipendentgroups");
    }

    public String getName() {
        return NbBundle.getMessage(RatesIndipendentGroups_Events_PersonsYear.class, (String)"RatesIndipendentGroups_Events_PersonsYear.name");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logRateRatioLabel");
    }
}

