/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsize.implementations.survival;

import java.io.Serializable;
import metaanalysis.effectsize.api.AbstractEffectSizeValue;
import metaanalysis.effectsizes.models.GenericSampleSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import metaanalysis.effectsizes.models.basicimplementation.HazardRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.LogHazardRatioEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HazardRatio_LL_UL_CI
extends AbstractEffectSizeValue
implements IEffectSizeValue,
Serializable {
    private double hazardRatio;
    private double lowerLimit;
    private double upperLimit;
    private double interval;

    public HazardRatio_LL_UL_CI() {
    }

    public HazardRatio_LL_UL_CI(double confidenceInterval, double hazardRatio, double lowerLimit, double upperLimit, double interval, int sampleSizeA, int sampleSizeB) {
        super(confidenceInterval, 1, (ISampleSizeValue)new GenericSampleSizeValue(sampleSizeA + sampleSizeB, sampleSizeA, sampleSizeB, 0, (double)sampleSizeA, (double)sampleSizeB));
        this.hazardRatio = hazardRatio;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.interval = interval;
    }

    public double getHazardRatio() {
        return this.hazardRatio;
    }

    public void setHazardRatio(double hazardRatio) {
        this.hazardRatio = hazardRatio;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
    }

    public double getInterval() {
        return this.interval;
    }

    public void setInterval(double interval) {
        this.interval = interval;
    }

    @Override
    public String getCalculationEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel");
    }

    @Override
    protected void fillAllConversions() {
    }

    @Override
    protected void elaborateOwnEffectSize() {
        try {
            this.setHazardRatioEffectSizeResults(new HazardRatioEffectSizeResults());
            this.setLogHazardRatioEffectSizeResults(new LogHazardRatioEffectSizeResults());
            this.getHazardRatioEffectSizeResults().setEffectSize(Double.valueOf(this.getHazardRatio()));
            this.getLogHazardRatioEffectSizeResults().setEffectSize(Double.valueOf(Math.log(this.getHazardRatio())));
            NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
            double z = normalDistribution.inverseCumulativeProbability((1.0 - this.interval) / 2.0);
            this.getLogHazardRatioEffectSizeResults().setUpperLimit(Double.valueOf(Math.log(this.upperLimit)));
            this.getLogHazardRatioEffectSizeResults().setLowerLimit(Double.valueOf(Math.log(this.lowerLimit)));
            this.getLogHazardRatioEffectSizeResults().setStandardError(Double.valueOf((this.getLogHazardRatioEffectSizeResults().getUpperLimit() - this.getLogHazardRatioEffectSizeResults().getLowerLimit()) / 2.0 / z));
            this.getLogHazardRatioEffectSizeResults().setVariance(Double.valueOf(Math.pow(this.getLogHazardRatioEffectSizeResults().getStandardError(), 2.0)));
            this.getLogHazardRatioEffectSizeResults().calcolateAllVariables(this.confidenceInterval);
            this.getHazardRatioEffectSizeResults().setLowerLimit(Double.valueOf(this.lowerLimit));
            this.getHazardRatioEffectSizeResults().setUpperLimit(Double.valueOf(this.upperLimit));
            this.getHazardRatioEffectSizeResults().setPValue(this.getLogHazardRatioEffectSizeResults().getPValue());
            this.getHazardRatioEffectSizeResults().setZValue(this.getLogHazardRatioEffectSizeResults().getZValue());
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getEffectSizeValueCategory() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"suvivalDataCategory");
    }

    public String getEffectSizeValueSubCategory() {
        return "";
    }

    public String getName() {
        return NbBundle.getMessage(HazardRatio_LL_UL_CI.class, (String)"Hazard_Ratio");
    }

    public String getConversionEffectSizeResultName() {
        return NbBundle.getMessage(IEffectSizeValue.class, (String)"logHazardRatioLabel");
    }
}

