/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.util.backup;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.application.tools.TopicFileFilter;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IDataFunctions;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.core.persistence.Project;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.core.persistence.Topic;
import metaanalysis.util.backup.BackupException;
import metaanalysis.util.backup.BackupPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class BackupBean
implements Serializable {
    protected Topic topic;
    protected List<Study> studies = new ArrayList<Study>();
    protected List<Subgroup> subgroups = new ArrayList<Subgroup>();
    protected List<Subgroupbranch> subgroupbranches = new ArrayList<Subgroupbranch>();
    protected List<Comparison> comparisons = new ArrayList<Comparison>();
    protected List<Comparisonbranch> comparisonbranches = new ArrayList<Comparisonbranch>();
    protected List<Outcome> outcomes = new ArrayList<Outcome>();
    protected List<Outcomebranch> outcomebranches = new ArrayList<Outcomebranch>();
    protected List<Moderator> moderators = new ArrayList<Moderator>();
    protected List<Moderatorlevel> moderatorlevels = new ArrayList<Moderatorlevel>();
    protected List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();
    protected List<Moderatorrecode> recodedModerators = new ArrayList<Moderatorrecode>();
    protected List<Project> projects = new ArrayList<Project>();
    protected List<Preanalysis> preanalysiss = new ArrayList<Preanalysis>();
    protected List<Timepointbranch> timepointbranches = new ArrayList<Timepointbranch>();

    public BackupBean() {
    }

    public BackupBean(long topicId, IDataFunctions f) {
        this.topic = f.getTopic(topicId);
        this.studies.addAll(f.getAllStudiesOfTopic(topicId));
        this.subgroups.addAll(f.getAllSubgroupsOfTopic(topicId));
        this.comparisons.addAll(f.getAllComparisonsOfTopic(topicId));
        this.outcomes.addAll(f.getAllOutcomesOfTopic(topicId));
        this.moderators.addAll(f.getAllModeratorsOfTopic(topicId));
        this.projects.addAll(f.getAllProjectsOfTopic(topicId));
        this.preanalysiss.addAll(f.getAllPreanalysisOfTopic(topicId));
        for (Study study : this.studies) {
            this.subgroupbranches.addAll(f.getAllSubgroupbranchesOfStudy(study.getId()));
        }
        for (Subgroupbranch subgroupbranch : this.subgroupbranches) {
            this.comparisonbranches.addAll(f.getAllComparisonbranchesOfSubgroupbranch(subgroupbranch.getId()));
        }
        for (Comparisonbranch comparisonbranch : this.comparisonbranches) {
            this.timepointbranches.addAll(f.getAllTimepointbranchesOfComparisonbranch(comparisonbranch.getId()));
        }
        for (Timepointbranch timepointbranch : this.timepointbranches) {
            this.outcomebranches.addAll(f.getAllOutcomebranchsOfTimepointbranch(timepointbranch.getId()));
        }
        for (Moderator moderator : this.moderators) {
            this.moderatorlevels.addAll(f.getAllModeratorLevelsOfModerator(moderator.getId()));
            this.moderatorvalues.addAll(f.getAllModeratorValuesOfModerator(moderator));
            this.recodedModerators.addAll(f.getAllModeratorrecodeOfModerator(moderator.getId()));
        }
    }

    public static BackupBean readFromFile(FileInputStream fis) {
        XMLDecoder d = null;
        try {
            d = new XMLDecoder(new GZIPInputStream(new BufferedInputStream(fis)));
        }
        catch (IOException ex) {
            Logger.getLogger(BackupBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        BackupBean result = (BackupBean)d.readObject();
        d.close();
        return result;
    }

    public void writeToFile(FileOutputStream fos) {
        XMLEncoder e = null;
        try {
            e = new XMLEncoder(new GZIPOutputStream(new BufferedOutputStream(fos)));
        }
        catch (IOException ex) {
            Logger.getLogger(BackupBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        e.writeObject(this);
        e.close();
    }

    public void fastBackup() throws BackupException {
        String backupDir = NbPreferences.root().get("backupDir", "");
        String automaticBackup = NbPreferences.root().get("automaticBackup", "false");
        if (backupDir.equals("")) {
            throw new BackupException(NbBundle.getMessage(BackupPanel.class, (String)"AutomaticBackupError"));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        Date date = new Date();
        File f = new File(backupDir + "/" + dateFormat.format(date) + "_" + this.topic.getName() + TopicFileFilter.proMetaFileExtension);
        try {
            FileOutputStream fos = new FileOutputStream(f);
            this.writeToFile(fos);
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            TuliTuliTools.whatAnError((String)NbBundle.getMessage(BackupPanel.class, (String)"AutomaticBackupError"));
        }
    }

    public void saveIntoDatabase(IDataFunctions iDataFunctions) throws BackupException {
        iDataFunctions.createTopic(this.topic, this.topic.getId());
        try {
            this.regenerateAll(iDataFunctions);
        }
        catch (BackupException ex) {
            iDataFunctions.removeTopic(this.topic);
            throw ex;
        }
    }

    public void cloneIntoDatabase(IDataFunctions iDataFunctions) throws BackupException {
        iDataFunctions.createTopic(this.topic);
        try {
            this.regenerateAll(iDataFunctions);
        }
        catch (BackupException ex) {
            iDataFunctions.removeTopic(this.topic);
            throw ex;
        }
    }

    private void regenerateAll(IDataFunctions iDataFunctions) throws BackupException {
        long oldValue;
        HashMap<Long, Long> fromTo = new HashMap<Long, Long>();
        HashMap<Integer, Integer> subgroupFromTo = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> comparisonFromTo = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> outcomeFromTo = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> moderatorFromTo = new HashMap<Integer, Integer>();
        HashMap<Long, Long> moderatorRecodeFromTo = new HashMap<Long, Long>();
        subgroupFromTo.put(-1, -1);
        comparisonFromTo.put(-1, -1);
        for (Study study : this.getStudies()) {
            study.setTopicId(Long.valueOf(this.topic.getId()));
            long oldValue2 = study.getId();
            iDataFunctions.createStudy(study);
            fromTo.put(oldValue2, study.getId());
        }
        for (Subgroup subgroup : this.getSubgroups()) {
            subgroup.setTopicId(Long.valueOf(this.topic.getId()));
            int oldValue3 = subgroup.getId();
            iDataFunctions.createSubgroup(subgroup);
            subgroupFromTo.put(oldValue3, subgroup.getId());
        }
        for (Comparison comparison : this.getComparisons()) {
            comparison.setTopicId(Long.valueOf(this.topic.getId()));
            int oldValue4 = comparison.getId();
            iDataFunctions.createComparison(comparison);
            comparisonFromTo.put(oldValue4, comparison.getId());
        }
        for (Outcome outcome : this.getOutcomes()) {
            outcome.setTopicId(Long.valueOf(this.topic.getId()));
            int oldValue5 = outcome.getId();
            iDataFunctions.createOutcome(outcome);
            outcomeFromTo.put(oldValue5, outcome.getId());
        }
        for (Moderator moderator : this.getModerators()) {
            moderator.setTopicId(Long.valueOf(this.topic.getId()));
            int oldValue6 = moderator.getId();
            iDataFunctions.createModerator(moderator);
            moderatorFromTo.put(oldValue6, moderator.getId());
        }
        for (Moderatorrecode moderatorrecode : this.getRecodedModerators()) {
            Integer get = (Integer)moderatorFromTo.get(moderatorrecode.getModeratorId());
            if (get == null) {
                throw new BackupException("Moderator Id null when clone moderatorrecode (old: " + moderatorrecode.getModeratorId() + ")");
            }
            moderatorrecode.setModeratorId(get);
            long oldValue7 = moderatorrecode.getId();
            iDataFunctions.createModeratorrecode(moderatorrecode);
            moderatorRecodeFromTo.put(oldValue7, moderatorrecode.getId());
        }
        for (Subgroupbranch subgroupbranch : this.getSubgroupbranches()) {
            Long get1 = (Long)fromTo.get(subgroupbranch.getStudyId());
            if (get1 == null) {
                throw new BackupException("Study Id null when clone Subgroupbranch (old: " + subgroupbranch.getStudyId() + ")");
            }
            Integer get2 = (Integer)subgroupFromTo.get(subgroupbranch.getSubgroupId());
            if (get2 == null) {
                throw new BackupException("Subgroup Id null when clone Subgroupbranch (old: " + subgroupbranch.getSubgroupId() + ")");
            }
            subgroupbranch.setStudyId(get1);
            subgroupbranch.setSubgroupId(get2);
            oldValue = subgroupbranch.getId();
            iDataFunctions.createSubgroupbranch(subgroupbranch);
            fromTo.put(oldValue, subgroupbranch.getId());
        }
        for (Comparisonbranch comparisonbranch : this.getComparisonbranches()) {
            Long get1 = (Long)fromTo.get(comparisonbranch.getSubgroupbranchId());
            if (get1 == null) {
                throw new BackupException("getSubgroupbranchId Id null when clone Comparisonbranch (old: " + comparisonbranch.getSubgroupbranchId() + ")");
            }
            Integer get2 = (Integer)comparisonFromTo.get(comparisonbranch.getComparisonId());
            if (get2 == null) {
                throw new BackupException("getComparisonId Id null when clone Comparisonbranch (old: " + comparisonbranch.getComparisonId() + ")");
            }
            comparisonbranch.setSubgroupbranchId(get1);
            comparisonbranch.setComparisonId(get2);
            oldValue = comparisonbranch.getId();
            iDataFunctions.createComparisonbranch(comparisonbranch);
            fromTo.put(oldValue, comparisonbranch.getId());
        }
        for (Timepointbranch timepointbranch : this.getTimepointbranches()) {
            Long get1 = (Long)fromTo.get(timepointbranch.getComparisonbranchId());
            if (get1 == null) {
                throw new BackupException("getComparisonbranchId Id null when clone Timepointbranch (old: " + timepointbranch.getComparisonbranchId() + ")");
            }
            timepointbranch.setComparisonbranchId(get1);
            long oldValue8 = timepointbranch.getId();
            iDataFunctions.createTimepointbranch(timepointbranch);
            fromTo.put(oldValue8, timepointbranch.getId());
        }
        for (Outcomebranch outcomebranch : this.getOutcomebranches()) {
            Long get1 = (Long)fromTo.get(outcomebranch.getTimepointbranchId());
            if (get1 == null) {
                throw new BackupException("getTimepointbranchId Id null when clone Outcomebranch (old: " + outcomebranch.getTimepointbranchId() + ")");
            }
            Integer get2 = (Integer)outcomeFromTo.get(outcomebranch.getOutcomeId());
            if (get2 == null) {
                throw new BackupException("getOutcomeId Id null when clone Outcomebranch (old: " + outcomebranch.getOutcomeId() + ")");
            }
            outcomebranch.setTimepointbranchId(get1);
            outcomebranch.setOutcomeId(get2);
            oldValue = outcomebranch.getId();
            iDataFunctions.createOutcomebranch(outcomebranch);
            fromTo.put(oldValue, outcomebranch.getId());
        }
        for (Moderatorlevel moderatorlevel : this.getModeratorlevels()) {
            Long get1 = (Long)fromTo.get(moderatorlevel.getId().getStudyId());
            if (get1 == null) {
                throw new BackupException("getStudyId Id null when clone Moderatorlevel (old: " + moderatorlevel.getId().getStudyId() + ")");
            }
            Integer get2 = (Integer)moderatorFromTo.get(moderatorlevel.getId().getModeratorId());
            if (get2 == null) {
                throw new BackupException("getId().getModeratorId() Id null when clone Moderatorlevel (old: " + moderatorlevel.getId().getModeratorId() + ")");
            }
            moderatorlevel.getId().setStudyId(get1.longValue());
            moderatorlevel.getId().setModeratorId(get2.intValue());
            iDataFunctions.saveModeratorlevel(moderatorlevel);
        }
        for (Moderatorvalue moderatorvalue : this.getModeratorvalues()) {
            Integer get1 = (Integer)moderatorFromTo.get(moderatorvalue.getId().getModeratorId());
            if (get1 == null) {
                throw new BackupException("getModeratorId Id null when clone Moderatorvalue (old: " + moderatorvalue.getId().getModeratorId() + ")");
            }
            Long get2 = (Long)fromTo.get(moderatorvalue.getId().getStudyId());
            if (get2 == null) {
                throw new BackupException("getId().getStudyId() Id null when clone Moderatorvalue (old: " + moderatorvalue.getId().getStudyId() + ")");
            }
            Long get3 = (Long)fromTo.get(moderatorvalue.getId().getLongidgenId());
            if (get2 == null) {
                throw new BackupException("getId().getLongidgenId() Id null when clone Moderatorvalue (old: " + moderatorvalue.getId().getLongidgenId() + ")");
            }
            moderatorvalue.getId().setModeratorId(get1.intValue());
            moderatorvalue.getId().setStudyId(get2.longValue());
            moderatorvalue.getId().setLongidgenId(get3.longValue());
            iDataFunctions.saveModeratorvalue(moderatorvalue);
        }
        for (Preanalysis preanalysis : this.getPreanalysiss()) {
            preanalysis.setTopicId(Long.valueOf(this.topic.getId()));
            iDataFunctions.createPreanalysis(preanalysis);
        }
        for (Project project : this.getProjects()) {
            Object tmp62;
            Object tmp222;
            Object tmp322;
            project.setTopicId(Long.valueOf(this.topic.getId()));
            AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
            List excludedCategoricalModerators = filter.getExcludedModerators();
            filter.setExcludedModerators(new ArrayList());
            for (Object tmp322 : excludedCategoricalModerators) {
                if (moderatorFromTo.get(tmp322) == null) {
                    throw new BackupException("moderatorFromTo null when clone Project (old: " + tmp322 + ")");
                }
                filter.getExcludedModerators().add(moderatorFromTo.get(tmp322));
            }
            List excludedComparisons = filter.getExcludedComparisons();
            filter.setExcludedComparisons(new ArrayList());
            tmp322 = excludedComparisons.iterator();
            while (tmp322.hasNext()) {
                Integer tmp4 = (Integer)tmp322.next();
                if (comparisonFromTo.get(tmp4) == null) {
                    throw new BackupException("comparisonFromTo null when clone Project (old: " + tmp4 + ")");
                }
                filter.getExcludedComparisons().add(comparisonFromTo.get(tmp4));
            }
            List ex1 = filter.getExcludedOutcomes();
            filter.setExcludedOutcomes(new ArrayList());
            for (Object tmp222 : ex1) {
                if (outcomeFromTo.get(tmp222) == null) {
                    throw new BackupException("outcomeFromTo null when clone Project (old: " + tmp222 + ")");
                }
                filter.getExcludedOutcomes().add(outcomeFromTo.get(tmp222));
            }
            List ex2 = filter.getExcludedRecodedModerators();
            filter.setExcludedRecodedModerators(new ArrayList());
            tmp222 = ex2.iterator();
            while (tmp222.hasNext()) {
                Long tmp5 = (Long)tmp222.next();
                if (moderatorRecodeFromTo.get(tmp5) == null) {
                    throw new BackupException("moderatorRecodeFromTo null when clone Project (old: " + tmp5 + ")");
                }
                filter.getExcludedRecodedModerators().add(moderatorRecodeFromTo.get(tmp5));
            }
            List ex3 = filter.getExcludedStudies();
            filter.setExcludedStudies(new ArrayList());
            for (Object tmp62 : ex3) {
                if (fromTo.get(tmp62) == null) {
                    throw new BackupException("fromTo (study) null when clone Project (old: " + tmp62 + ")");
                }
                filter.getExcludedStudies().add(fromTo.get(tmp62));
            }
            List ex4 = filter.getExcludedSubgroups();
            filter.setExcludedSubgroups(new ArrayList());
            tmp62 = ex4.iterator();
            while (tmp62.hasNext()) {
                Integer tmp7 = (Integer)tmp62.next();
                if (subgroupFromTo.get(tmp7) == null) {
                    throw new BackupException("subgroupFromTo null when clone Project (old: " + tmp7 + ")");
                }
                filter.getExcludedSubgroups().add(subgroupFromTo.get(tmp7));
            }
            project.setFilter(AnalysisFilter.writeAnalysisFilter((AnalysisFilter)filter));
            long oldValue9 = project.getId();
            iDataFunctions.createProject(project);
        }
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public List<Study> getStudies() {
        return this.studies;
    }

    public void setStudies(List<Study> studies) {
        this.studies = studies;
    }

    public List<Subgroup> getSubgroups() {
        return this.subgroups;
    }

    public void setSubgroups(List<Subgroup> subgroups) {
        this.subgroups = subgroups;
    }

    public List<Subgroupbranch> getSubgroupbranches() {
        return this.subgroupbranches;
    }

    public void setSubgroupbranches(List<Subgroupbranch> subgroupbranches) {
        this.subgroupbranches = subgroupbranches;
    }

    public List<Comparison> getComparisons() {
        return this.comparisons;
    }

    public void setComparisons(List<Comparison> comparisons) {
        this.comparisons = comparisons;
    }

    public List<Comparisonbranch> getComparisonbranches() {
        return this.comparisonbranches;
    }

    public void setComparisonbranches(List<Comparisonbranch> comparisonbranches) {
        this.comparisonbranches = comparisonbranches;
    }

    public List<Outcome> getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(List<Outcome> outcomes) {
        this.outcomes = outcomes;
    }

    public List<Outcomebranch> getOutcomebranches() {
        return this.outcomebranches;
    }

    public void setOutcomebranches(List<Outcomebranch> outcomebranches) {
        this.outcomebranches = outcomebranches;
    }

    public List<Moderator> getModerators() {
        return this.moderators;
    }

    public void setModerators(List<Moderator> moderators) {
        this.moderators = moderators;
    }

    public List<Moderatorlevel> getModeratorlevels() {
        return this.moderatorlevels;
    }

    public void setModeratorlevels(List<Moderatorlevel> moderatorlevels) {
        this.moderatorlevels = moderatorlevels;
    }

    public List<Moderatorvalue> getModeratorvalues() {
        return this.moderatorvalues;
    }

    public void setModeratorvalues(List<Moderatorvalue> moderatorvalues) {
        this.moderatorvalues = moderatorvalues;
    }

    public List<Moderatorrecode> getRecodedModerators() {
        return this.recodedModerators;
    }

    public void setRecodedModerators(List<Moderatorrecode> recodedModerators) {
        this.recodedModerators = recodedModerators;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public List<Preanalysis> getPreanalysiss() {
        return this.preanalysiss;
    }

    public void setPreanalysiss(List<Preanalysis> preanalysiss) {
        this.preanalysiss = preanalysiss;
    }

    public List<Timepointbranch> getTimepointbranches() {
        return this.timepointbranches;
    }

    public void setTimepointbranches(List<Timepointbranch> timepointbranches) {
        this.timepointbranches = timepointbranches;
    }
}

