/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.util.backup;

import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import metaanalysis.application.tools.TopicFileFilter;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TopicOpenedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.util.backup.BackupBean;
import metaanalysis.util.backup.BackupException;
import org.openide.util.NbBundle;

public class BackupFunctions {
    public static boolean cloneTopic(Topic topic, IApplicationManager iApplicationManager) throws BackupException {
        BackupBean backupBean = new BackupBean(topic.getId(), iApplicationManager.getIDataFunction());
        String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(BackupFunctions.class, (String)"AA.CloneTopicAA.clonedTopicName"), NbBundle.getMessage(BackupFunctions.class, (String)"AA.CloneTopicAA.cloneTopicBarTitle"), 1);
        if (nome != null && !"".equals(nome)) {
            backupBean.getTopic().setName(nome);
            try {
                backupBean.cloneIntoDatabase(iApplicationManager.getIDataFunction());
                Topic t = backupBean.getTopic();
                Topic firstOpenedTopic = iApplicationManager.getIDataFunction().getFirstOpenedTopic();
                iApplicationManager.getIDataFunction().openOneTopic(t);
                iApplicationManager.setApplicationEvent((IApplicationEvent)new TopicOpenedEvent(t, firstOpenedTopic));
                return true;
            }
            catch (BackupException ex) {
                TuliTuliTools.whatAnError((String)ex.getMessage());
            }
        }
        return false;
    }

    public static void exportTopicToFile(Topic topic, IApplicationManager iApplicationManager) throws BackupException {
        BackupBean backupBean = new BackupBean(topic.getId(), iApplicationManager.getIDataFunction());
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        TopicFileFilter topicFileFilter = new TopicFileFilter();
        fc.setFileFilter((FileFilter)topicFileFilter);
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            String msg;
            int r;
            File file = fc.getSelectedFile();
            if (file.exists() && (r = JOptionPane.showConfirmDialog(null, msg = NbBundle.getMessage(BackupFunctions.class, (String)"exportTopic.action"), "Confirm", 0)) == 1) {
                return;
            }
            if (fc.getFileFilter() == topicFileFilter && !file.getName().toLowerCase().endsWith(TopicFileFilter.proMetaFileExtension)) {
                file = new File(file.getPath() + TopicFileFilter.proMetaFileExtension);
            }
            try {
                FileOutputStream fos = new FileOutputStream(file);
                backupBean.writeToFile(fos);
                fos.flush();
                fos.close();
            }
            catch (Exception ex) {
                throw new BackupException(ex.getMessage());
            }
        } else {
            throw new BackupException(NbBundle.getMessage(BackupFunctions.class, (String)"operazione.annullata"));
        }
    }
}

