/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.util.backup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.util.backup.BackupOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class BackupPanel
extends JPanel {
    private final BackupOptionsPanelController controller;
    private JCheckBox automaticBackupField;
    private JTextField backupDirField;
    private JButton jButton1;
    private JLabel jLabel1;

    BackupPanel(BackupOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.backupDirField = new JTextField();
        this.automaticBackupField = new JCheckBox();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.backupDirField.setEditable(false);
        this.backupDirField.setText(NbBundle.getMessage(BackupPanel.class, (String)"BackupPanel.backupDirField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.automaticBackupField, (String)NbBundle.getMessage(BackupPanel.class, (String)"BackupPanel.automaticBackupField.text"));
        this.automaticBackupField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackupPanel.this.automaticBackupFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(BackupPanel.class, (String)"BackupPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackupPanel.this.jButton1ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BackupPanel.class, (String)"BackupPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.automaticBackupField).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.backupDirField, GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)))).addContainerGap(60, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backupDirField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.automaticBackupField).addContainerGap(44, Short.MAX_VALUE)));
    }

    private void automaticBackupFieldActionPerformed(ActionEvent evt) {
        if ("".equals(this.backupDirField.getText())) {
            this.automaticBackupField.setSelected(false);
            TuliTuliTools.whatAnError((String)NbBundle.getMessage(BackupPanel.class, (String)"AutomaticBackupError"));
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.backupDirField.setText(file.getPath());
        }
    }

    void load() {
        this.backupDirField.setText(NbPreferences.root().get("backupDir", ""));
        if (NbPreferences.root().get("automaticBackup", "false").equals("false")) {
            this.automaticBackupField.setSelected(false);
        } else {
            this.automaticBackupField.setSelected(true);
        }
    }

    void store() {
        NbPreferences.root().put("backupDir", this.backupDirField.getText());
        if (this.automaticBackupField.isSelected()) {
            NbPreferences.root().put("automaticBackup", "true");
        } else {
            NbPreferences.root().put("automaticBackup", "false");
        }
    }

    boolean valid() {
        return true;
    }
}

