/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.plugins.projectexplorer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TopicDeletedEvent;
import metaanalysis.core.functionsapi.events.TopicOpenedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.plugins.projectexplorer.Bundle;
import metaanalysis.projects.guiandnodes.ProjectsContainerNode;
import metaanalysis.projects.guiandnodes.childfactory.ProjectsChildFactory;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ProjectsExplorerTopComponent", iconBase="metaanalysis/application/style/project_icon.png", persistenceType=0)
public final class ProjectsExplorerTopComponent
extends TopComponent
implements PropertyChangeListener,
ExplorerManager.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    protected BeanTreeView albero = new BeanTreeView();
    protected Node projectsNode;
    private JScrollPane jScrollPane1;

    public ProjectsExplorerTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ProjectsExplorerTopComponent());
        this.setToolTipText(Bundle.HINT_ProjectsExplorerTopComponent());
        this.jScrollPane1.setBackground(StyleProvider.panelBackground);
        this.albero.setBackground(StyleProvider.panelBackground);
        IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
        iApplicationManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)Lookup.getDefault().lookup(IApplicationManager.class)));
        ActionMap map = this.getActionMap();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map));
        this.aggiorna();
    }

    private void aggiorna() {
        IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
        List allOpenedTopics = iApplicationManager.getIDataFunction().getAllOpenedTopics();
        if (!allOpenedTopics.isEmpty()) {
            this.projectsNode = new ProjectsContainerNode((Topic)allOpenedTopics.get(0), iApplicationManager, Children.create((ChildFactory)new ProjectsChildFactory((Topic)allOpenedTopics.get(0), iApplicationManager), (boolean)true));
            this.explorerManager.setRootContext(this.projectsNode);
        } else {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName("No topic opened");
            this.explorerManager.setRootContext((Node)abstractNode);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = this.albero;
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getNewValue() instanceof TopicDeletedEvent || pce.getNewValue() instanceof TopicOpenedEvent) {
            this.aggiorna();
            this.validate();
        } else if (pce.getNewValue() instanceof ExpandNode) {
            final Node node = ((ExpandNode)pce.getNewValue()).getNode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectsExplorerTopComponent.this.albero.expandNode(node);
                }
            });
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public UndoRedo.Manager getUndoRedo() {
        return ((IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class)).getMainUndoRedoManager();
    }

    public HelpCtx getHelpCtx() {
        Node[] selectedNodes = this.explorerManager.getSelectedNodes();
        if (selectedNodes.length < 1) {
            return super.getHelpCtx();
        }
        return selectedNodes[0].getHelpCtx();
    }
}

