/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.meanstandarddeviationsamplesize;

import formattazione.numeri.MyNumberFormatter;

public class MeanESRow {
    private String name;
    private Double mean1;
    private Double mean2;
    private Double standardDeviation1;
    private Double standardDeviation2;
    private Integer n1;
    private Integer n2;

    public MeanESRow() {
    }

    public MeanESRow(String name, Double mean1, Double mean2, Double standardDeviation1, Double standardDeviation2, Integer n1, Integer n2) {
        this.name = name;
        this.mean1 = mean1;
        this.mean2 = mean2;
        this.standardDeviation1 = standardDeviation1;
        this.standardDeviation2 = standardDeviation2;
        this.n1 = n1;
        this.n2 = n2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getMean1() {
        return this.mean1;
    }

    public void setMean1(Double mean1) {
        this.mean1 = mean1;
    }

    public Double getMean2() {
        return this.mean2;
    }

    public void setMean2(Double mean2) {
        this.mean2 = mean2;
    }

    public Double getStandardDeviation1() {
        return this.standardDeviation1;
    }

    public void setStandardDeviation1(Double standardDeviation1) {
        this.standardDeviation1 = standardDeviation1;
    }

    public Double getStandardDeviation2() {
        return this.standardDeviation2;
    }

    public void setStandardDeviation2(Double standardDeviation2) {
        this.standardDeviation2 = standardDeviation2;
    }

    public Integer getN1() {
        return this.n1;
    }

    public void setN1(Integer n1) {
        this.n1 = n1;
    }

    public Integer getN2() {
        return this.n2;
    }

    public void setN2(Integer n2) {
        this.n2 = n2;
    }

    public static MeanESRow createFromText(String text, MyNumberFormatter myNumberFormatter) {
        MeanESRow row = new MeanESRow();
        String[] campi = text.split("\t");
        for (int i = 0; i < campi.length; ++i) {
            if (i == 0) {
                row.setName(campi[i]);
            }
            if (i == 1) {
                try {
                    row.setMean1(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 4) {
                try {
                    row.setMean2(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 2) {
                try {
                    row.setStandardDeviation1(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 5) {
                try {
                    row.setStandardDeviation2(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 3) {
                try {
                    row.setN1(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i != 6) continue;
            try {
                row.setN2(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return row;
    }

    public String toText(MyNumberFormatter myNumberFormatter) {
        return (this.name == null ? "" : this.name) + "\t" + (this.mean1 == null ? "" : myNumberFormatter.formatInLang(this.mean1.doubleValue())) + "\t" + (this.standardDeviation1 == null ? "" : myNumberFormatter.formatInLang(this.standardDeviation1.doubleValue())) + "\t" + (this.n1 == null ? "" : myNumberFormatter.formatInLang(this.n1.intValue())) + "\t" + (this.mean2 == null ? "" : myNumberFormatter.formatInLang(this.mean2.doubleValue())) + "\t" + (this.standardDeviation2 == null ? "" : myNumberFormatter.formatInLang(this.standardDeviation2.doubleValue())) + "\t" + (this.n2 == null ? "" : myNumberFormatter.formatInLang(this.n2.intValue()));
    }

    public boolean isVoid() {
        return this.name == null && this.mean1 == null && this.standardDeviation1 == null && this.n1 == null && this.mean2 == null && this.standardDeviation2 == null && this.n2 == null;
    }
}

