/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.meanstandarddeviationsamplesize;

import effectsizeplot.api.AEffectSizeEditorPanel;
import effectsizeplot.api.IEffectSizeSource;
import effectsizeplot.api.ITextImporterExporter;
import effectsizeplot.api.ImportExportTextException;
import effectsizeplot.input.meanstandarddeviationsamplesize.MeanESPanel;
import effectsizeplot.input.meanstandarddeviationsamplesize.MeanESRow;
import forestplot.api.BloccoDiRighe;
import forestplot.api.ColoumnDescripotrsFactory;
import forestplot.api.DataEntryRow;
import forestplot.api.IScale;
import forestplot.api.LinearScale;
import forestplot.api.PlotInputData;
import forestplot.api.VisualizerBean;
import formattazione.numeri.MyNumberFormatter;
import internovi.numbers.locale.provider.LocaleNumbersProvider;
import internovi.statisticaloptions.provider.StatisticalOptionProvider;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openide.util.NbBundle;

public class MeanESSourceBean
implements ITextImporterExporter,
IEffectSizeSource,
Serializable {
    private IScale scale;
    public static int rowsNumber = 100;
    private VisualizerBean visualizerBean = new VisualizerBean();
    private MeanESRow[] righe = new MeanESRow[rowsNumber];
    public static String esName = NbBundle.getMessage(MeanESSourceBean.class, (String)"meanES.name");

    public MeanESSourceBean() {
        for (int i = 0; i < rowsNumber; ++i) {
            this.righe[i] = new MeanESRow();
        }
    }

    public VisualizerBean getVisualizerBean() {
        return this.visualizerBean;
    }

    public void setVisualizerBean(VisualizerBean visualizerBean) {
        this.visualizerBean = visualizerBean;
    }

    public String getTipoDiScala() {
        return NbBundle.getMessage(MeanESSourceBean.class, (String)"scale.linear.name");
    }

    public MeanESRow[] getRighe() {
        return this.righe;
    }

    public void setRighe(MeanESRow[] righe) {
        this.righe = righe;
    }

    public MeanESRow getRighe(int index) {
        return this.righe[index];
    }

    public void setRighe(int index, MeanESRow newRighe) {
        this.righe[index] = newRighe;
    }

    public void writeToFile(OutputStream os) {
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(os));
        e.writeObject(this);
        e.close();
    }

    public void saveToStream(OutputStream os) {
        this.writeToFile(os);
    }

    public AEffectSizeEditorPanel getEditor() {
        return new MeanESPanel(this);
    }

    public PlotInputData getPlotInputData() {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        BloccoDiRighe blocco = new BloccoDiRighe();
        PlotInputData plotInputData = new PlotInputData();
        plotInputData.getBlocchiRighe().add((Object)blocco);
        plotInputData.setColonne(ColoumnDescripotrsFactory.generateEffectSizePlotterDescriptors((MyNumberFormatter)myFormatter));
        for (int i = 0; i < rowsNumber; ++i) {
            try {
                double sWithin = Math.sqrt(((1.0 * (double)this.righe[i].getN1().intValue() - 1.0) * this.righe[i].getStandardDeviation1() * this.righe[i].getStandardDeviation1() + (1.0 * (double)this.righe[i].getN2().intValue() - 1.0) * this.righe[i].getStandardDeviation2() * this.righe[i].getStandardDeviation2()) / (1.0 * (double)(this.righe[i].getN1() + this.righe[i].getN2() - 2)));
                DataEntryRow row = new DataEntryRow();
                row.setName(this.righe[i].getName());
                row.setEffectSize((this.righe[i].getMean1() - this.righe[i].getMean2()) / sWithin);
                double primo = (1.0 * (double)this.righe[i].getN1().intValue() + 1.0 * (double)this.righe[i].getN2().intValue()) / (1.0 * (double)this.righe[i].getN1().intValue() * 1.0 * (double)this.righe[i].getN2().intValue());
                double secondo = 1.0 * row.getEffectSize() * row.getEffectSize() / (2.0 * (1.0 * (double)this.righe[i].getN1().intValue() + 1.0 * (double)this.righe[i].getN2().intValue()));
                double v = primo + secondo;
                double stdErr = Math.sqrt(v);
                row.setVariance(Double.valueOf(v));
                row.setStandardError(Double.valueOf(stdErr));
                row.setLowerLimit(Double.valueOf(row.getEffectSize() - 1.96 * stdErr));
                row.setUpperLimit(Double.valueOf(row.getEffectSize() + 1.96 * stdErr));
                row.setSampleSize(this.righe[i].getN1() + this.righe[i].getN2());
                row.setN1(this.righe[i].getN1().intValue());
                row.setN2(this.righe[i].getN2().intValue());
                blocco.add((Object)row);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.scale = new LinearScale(plotInputData);
        plotInputData.setVisualizerBean(this.visualizerBean);
        plotInputData.setUp();
        return plotInputData;
    }

    public String getEffectSizeTypeName() {
        return esName;
    }

    public void importFromText(String text, boolean append) throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String testo = "";
        if (append) {
            testo = this.exportToText();
        }
        if (!testo.equals("")) {
            testo = testo + "\n";
        }
        testo = testo + text;
        String[] arr = testo.split("\n");
        for (int r = 0; r < arr.length; ++r) {
            this.righe[r] = MeanESRow.createFromText(arr[r], myFormatter);
        }
        for (int k = arr.length; k < rowsNumber; ++k) {
            this.righe[k] = new MeanESRow();
        }
    }

    public String exportToText() throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String ret = "";
        String aCapo = "";
        for (MeanESRow x : this.righe) {
            if (x.isVoid()) continue;
            ret = ret + aCapo + x.toText(myFormatter);
            aCapo = "\n";
        }
        return ret;
    }

    public IScale getScale() {
        return this.scale;
    }
}

