/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsizes.models;

import java.io.Serializable;
import java.text.DecimalFormat;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public abstract class AbstractEffectSizeResults
implements IEffectSizeResults,
Serializable {
    private transient NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
    protected Double effectSize = null;
    protected Double standardError = null;
    protected Double variance = null;
    protected Double lowerLimit = null;
    protected Double upperLimit = null;
    protected Double zValue = null;
    protected Double pValue = null;
    DecimalFormat f3d = new DecimalFormat("#.###");
    DecimalFormat f5d = new DecimalFormat("#.#####");

    public AbstractEffectSizeResults() {
    }

    public AbstractEffectSizeResults(Double effectSize, Double standardError, Double variance, Double lowerLimit, Double upperLimit, Double zValue, Double pValue) {
        this.pValue = pValue;
        this.effectSize = effectSize;
        this.standardError = standardError;
        this.variance = variance;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.zValue = zValue;
    }

    @Override
    public Double getEffectSize() {
        return this.effectSize;
    }

    public void setEffectSize(Double effectSize) {
        this.effectSize = effectSize;
    }

    @Override
    public Double getStandardError() {
        return this.standardError;
    }

    public void setStandardError(Double standardError) {
        this.standardError = standardError;
    }

    @Override
    public Double getVariance() {
        return this.variance;
    }

    public void setVariance(Double variance) {
        this.variance = variance;
    }

    @Override
    public Double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(Double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    @Override
    public Double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(Double upperLimit) {
        this.upperLimit = upperLimit;
    }

    @Override
    public Double getZValue() {
        return this.zValue;
    }

    public void setZValue(Double zValue) {
        this.zValue = zValue;
    }

    @Override
    public Double getPValue() {
        return this.pValue;
    }

    public void setPValue(Double pValue) {
        this.pValue = pValue;
    }

    public void copyFrom(IEffectSizeResults effectSizeResults) {
        this.effectSize = effectSizeResults.getEffectSize();
        this.lowerLimit = effectSizeResults.getLowerLimit();
        this.pValue = effectSizeResults.getPValue();
        this.standardError = effectSizeResults.getStandardError();
        this.upperLimit = effectSizeResults.getUpperLimit();
        this.variance = effectSizeResults.getVariance();
        this.zValue = effectSizeResults.getZValue();
    }

    public final String to3d(Double d) {
        if (d == null) {
            return null;
        }
        return this.f3d.format(d);
    }

    public final String to5d(Double d) {
        if (d == null) {
            return null;
        }
        return this.f5d.format(d);
    }

    public final void calcolateAllVariables(double confidenceInterval) {
        this.calculateStandardError();
        this.calculateLimits(confidenceInterval);
        this.calculateZValue();
        this.calculatePValue();
    }

    public void setEffectSize(double effectSize, int direction) {
        this.setEffectSize(effectSize);
        if (direction == 2) {
            this.effectSize = Math.abs(this.effectSize);
        }
        if (direction == 3) {
            this.effectSize = -1.0 * Math.abs(this.effectSize);
        }
    }

    protected final void calculateStandardError() {
        this.setStandardError(Math.sqrt(this.getVariance()));
    }

    protected final void calculateLimits(double confidenceInterval) {
        this.setLowerLimit(this.getEffectSize() - confidenceInterval * this.getStandardError());
        this.setUpperLimit(this.getEffectSize() + confidenceInterval * this.getStandardError());
    }

    protected final void calculateZValue() {
        this.setZValue(this.getEffectSize() / this.getStandardError());
    }

    protected final void calculatePValue() {
        try {
            this.pValue = (1.0 - this.normalDistribution.cumulativeProbability(Math.abs(this.getZValue()))) * 2.0;
        }
        catch (MathException ex) {
            this.pValue = null;
        }
    }
}

