/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsizes.models;

import metaanalysis.effectsizes.models.GenericEffectSizeResults;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.CohensDEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.CorrelationEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.FishersZEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.HedgessGEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.LogOddsRatioEffectSizeResults;
import metaanalysis.effectsizes.models.basicimplementation.OddsRatioEffectSizeResults;

public class ESRConversions {
    public static FishersZEffectSizeResults fromCorrelationToFhiserZ(CorrelationEffectSizeResults correlationEffectSizeResults, double confidenceInterval, double sampleSize) {
        FishersZEffectSizeResults x = new FishersZEffectSizeResults();
        x.setEffectSize(0.5 * Math.log((1.0 + correlationEffectSizeResults.getEffectSize()) / (1.0 - correlationEffectSizeResults.getEffectSize())));
        x.setStandardError(correlationEffectSizeResults.getStandardError() / (1.0 - Math.pow(correlationEffectSizeResults.getEffectSize(), 2.0)));
        x.setVariance(Math.pow(x.getStandardError(), 2.0));
        x.calcolateAllVariables(confidenceInterval);
        return x;
    }

    public static CorrelationEffectSizeResults fromFisherZToCorrelation(IEffectSizeResults fishersZEffectSizeResults, double confidenceInterval) {
        CorrelationEffectSizeResults x = new CorrelationEffectSizeResults();
        x.setEffectSize(ESRConversions.simpleConversionFromFisherToR(fishersZEffectSizeResults.getEffectSize()));
        double ser = (1.0 - Math.pow(x.getEffectSize(), 2.0)) * fishersZEffectSizeResults.getStandardError();
        x.setVariance(Math.pow(ser, 2.0));
        x.calcolateAllVariables(confidenceInterval);
        return x;
    }

    public static CohensDEffectSizeResults fromCorrelationToChoenD(CorrelationEffectSizeResults correlationEffectSizeResults, double confidenceInterval) {
        CohensDEffectSizeResults x = new CohensDEffectSizeResults();
        x.setEffectSize(correlationEffectSizeResults.getEffectSize() * 2.0 / Math.sqrt(1.0 - correlationEffectSizeResults.getEffectSize() * correlationEffectSizeResults.getEffectSize()));
        x.setVariance(4.0 * correlationEffectSizeResults.getVariance() / Math.pow(1.0 - correlationEffectSizeResults.getEffectSize() * correlationEffectSizeResults.getEffectSize(), 3.0));
        x.calcolateAllVariables(confidenceInterval);
        return x;
    }

    public static LogOddsRatioEffectSizeResults fromChoenDToLogOddsRatio(CohensDEffectSizeResults cohensDEffectSizeResults, double confidenceInterval) {
        LogOddsRatioEffectSizeResults x = new LogOddsRatioEffectSizeResults();
        x.setEffectSize(Math.PI * cohensDEffectSizeResults.getEffectSize() / Math.sqrt(3.0));
        x.setVariance(Math.PI * Math.PI * cohensDEffectSizeResults.getVariance() / 3.0);
        x.calcolateAllVariables(confidenceInterval);
        return x;
    }

    public static OddsRatioEffectSizeResults fromLogOddsRatioToOddsRatio(IEffectSizeResults logOddsRatioEffectSizeResults, double confidenceInterval) {
        OddsRatioEffectSizeResults x = new OddsRatioEffectSizeResults();
        x.setEffectSize(Math.exp(logOddsRatioEffectSizeResults.getEffectSize()));
        x.setVariance(null);
        x.setPValue(logOddsRatioEffectSizeResults.getPValue());
        x.setZValue(logOddsRatioEffectSizeResults.getZValue());
        x.setStandardError(null);
        x.setUpperLimit(Math.exp(logOddsRatioEffectSizeResults.getUpperLimit()));
        x.setLowerLimit(Math.exp(logOddsRatioEffectSizeResults.getLowerLimit()));
        return x;
    }

    public static CohensDEffectSizeResults fromLogOddsRatioToChoenD(LogOddsRatioEffectSizeResults logOddsRatioEffectSizeResults, double confidenceInterval) {
        CohensDEffectSizeResults x = new CohensDEffectSizeResults();
        x.setEffectSize(Math.sqrt(3.0) * logOddsRatioEffectSizeResults.getEffectSize() / Math.PI);
        x.setVariance(3.0 * logOddsRatioEffectSizeResults.getVariance() / Math.pow(Math.PI, 2.0));
        x.calcolateAllVariables(confidenceInterval);
        return x;
    }

    public static HedgessGEffectSizeResults fromChoenDToHedgesG(CohensDEffectSizeResults cohensDEffectSizeResults, double confidenceInterval, double sampleSize, int df) {
        HedgessGEffectSizeResults x = new HedgessGEffectSizeResults();
        double j = 1.0 - 3.0 / (4.0 * (double)df - 1.0);
        x.setEffectSize(j * cohensDEffectSizeResults.getEffectSize());
        x.setVariance(j * j * cohensDEffectSizeResults.getVariance());
        x.calcolateAllVariables(confidenceInterval);
        return x;
    }

    public static CorrelationEffectSizeResults fromChoenDToCorrelation(CohensDEffectSizeResults cohensDEffectSizeResults, double confidenceInterval, double sampleSizeA, double sampleSizeB) {
        CorrelationEffectSizeResults x = new CorrelationEffectSizeResults();
        double a = 1.0 * (sampleSizeA + sampleSizeB) * (sampleSizeA + sampleSizeB) / (sampleSizeA * sampleSizeB);
        x.setEffectSize(cohensDEffectSizeResults.getEffectSize() / Math.sqrt(cohensDEffectSizeResults.getEffectSize() * cohensDEffectSizeResults.getEffectSize() + a));
        x.setVariance(a * a * cohensDEffectSizeResults.getVariance() / Math.pow(cohensDEffectSizeResults.getEffectSize() * cohensDEffectSizeResults.getEffectSize() + a, 3.0));
        x.calcolateAllVariables(confidenceInterval);
        return x;
    }

    public static double simpleConversionFromFisherToR(double z) {
        return (Math.pow(Math.E, z * 2.0) - 1.0) / (Math.pow(Math.E, z * 2.0) + 1.0);
    }

    public static IEffectSizeResults convertFromLogToNormal(IEffectSizeResults source) {
        GenericEffectSizeResults tmp = new GenericEffectSizeResults();
        tmp.setEffectSize(Math.exp(source.getEffectSize()));
        tmp.setUpperLimit(Math.exp(source.getUpperLimit()));
        tmp.setLowerLimit(Math.exp(source.getLowerLimit()));
        tmp.setPValue(source.getPValue());
        tmp.setZValue(source.getZValue());
        return tmp;
    }

    public static IEffectSizeResults convertFromLogRateEventToNormalRateEvent(IEffectSizeResults source) {
        GenericEffectSizeResults tmp = new GenericEffectSizeResults();
        tmp.setEffectSize(Math.exp(source.getEffectSize()) / (Math.exp(source.getEffectSize()) + 1.0));
        tmp.setUpperLimit(Math.exp(source.getUpperLimit()) / (Math.exp(source.getUpperLimit()) + 1.0));
        tmp.setLowerLimit(Math.exp(source.getLowerLimit()) / (Math.exp(source.getLowerLimit()) + 1.0));
        tmp.setPValue(source.getPValue());
        tmp.setZValue(source.getZValue());
        return tmp;
    }
}

