/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsizes.models;

import forestplot.api.IScale;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ESVTools {
    public static int linearScale = 0;
    public static int logScale = 1;

    public static String toString(IEffectSizeValue es) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(baos);
        xmlEncoder.writeObject(es);
        xmlEncoder.close();
        return baos.toString();
    }

    public static IEffectSizeValue toESV(String es) {
        if (es == null || es.equals("")) {
            return null;
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(es.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        XMLDecoder d = new XMLDecoder(is);
        Object result = d.readObject();
        d.close();
        return (IEffectSizeValue)result;
    }

    public static String getPreferrredScale(String esValueName) {
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hedgessGLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rowDifferenceInMeansLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"standardPairedDifferenceLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskDifferenceLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHRiskDifferenceLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.mean")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.rate")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"fishersZLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logRateRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logOddsRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHLogOddsRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logPetoOddsRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logRiskRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHLogRiskRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logHazardRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.logEventRate"))) {
            return NbBundle.getMessage(IScale.class, (String)"scale.linear.name");
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel"))) {
            return NbBundle.getMessage(IScale.class, (String)"scale.fisher.name");
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHOddsRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"petoOddsRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHRiskRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateDifferenceLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel")) || esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate"))) {
            return NbBundle.getMessage(IScale.class, (String)"scale.log.name");
        }
        return NbBundle.getMessage(IScale.class, (String)"scale.linear.name");
    }

    public static int getNullValue(String esValueName) {
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"cohensDLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hedgessGLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rowDifferenceInMeansLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"standardPairedDifferenceLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"fishersZLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskDifferenceLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHRiskDifferenceLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"petoOddsRatioLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logPetoOddsRatioLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logOddsRatioLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logRateRatioLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHOddsRatioLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHLogOddsRatioLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logRiskRatioLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHRiskRatioLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"mHLogRiskRatioLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateDifferenceLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"logHazardRatioLabel"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.mean"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate"))) {
            return 1;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.logEventRate"))) {
            return 0;
        }
        if (esValueName.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.rate"))) {
            return 0;
        }
        return 0;
    }
}

