/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsizes.models;

import java.io.Serializable;
import java.util.List;
import metaanalysis.effectsizes.models.ISampleSizeValue;

public class GenericSampleSizeValue
implements ISampleSizeValue,
Serializable {
    protected double estimateGroupB;
    protected double estimateGroupA;
    protected int sampleSize = 0;
    protected int groupASize = 0;
    protected int groupBSize = 0;
    protected int notSignedSize = 0;

    public GenericSampleSizeValue(int sampleSize, int groupASize, int groupBSize, int notSignedSize, double estimateGroupA, double estimateGroupB) {
        this.sampleSize = sampleSize;
        this.groupASize = groupASize;
        this.groupBSize = groupBSize;
        this.notSignedSize = notSignedSize;
        this.estimateGroupA = estimateGroupA;
        this.estimateGroupB = estimateGroupB;
    }

    public GenericSampleSizeValue() {
        this.sampleSize = 0;
        this.groupASize = 0;
        this.groupBSize = 0;
        this.notSignedSize = 0;
        this.estimateGroupA = 0.0;
        this.estimateGroupB = 0.0;
    }

    public GenericSampleSizeValue(int sampleSize) {
        this.sampleSize = sampleSize;
        this.groupASize = 0;
        this.groupBSize = 0;
        this.notSignedSize = sampleSize;
        this.estimateGroupA = 1.0 * (double)sampleSize / 2.0;
        this.estimateGroupB = 1.0 * (double)sampleSize / 2.0;
    }

    @Override
    public double getEstimateGroupB() {
        return this.estimateGroupB;
    }

    public void setEstimateGroupB(double estimateGroupB) {
        this.estimateGroupB = estimateGroupB;
    }

    @Override
    public double getEstimateGroupA() {
        return this.estimateGroupA;
    }

    public void setEstimateGroupA(double estimateGroupA) {
        this.estimateGroupA = estimateGroupA;
    }

    public void setGroupASize(int groupASize) {
        this.groupASize = groupASize;
    }

    public void setGroupBSize(int groupBSize) {
        this.groupBSize = groupBSize;
    }

    public void setNotSignedSize(int notSignedSize) {
        this.notSignedSize = notSignedSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public int getGroupASize() {
        return this.groupASize;
    }

    @Override
    public int getGroupBSize() {
        return this.groupBSize;
    }

    @Override
    public int getNotSignedSize() {
        return this.notSignedSize;
    }

    public void sum(ISampleSizeValue sampleSize) {
        this.groupASize += sampleSize.getGroupASize();
        this.groupBSize += sampleSize.getGroupBSize();
        this.sampleSize += sampleSize.getSampleSize();
        this.notSignedSize += sampleSize.getNotSignedSize();
    }

    public static ISampleSizeValue meanSampleSize(List<ISampleSizeValue> sampleSizes) {
        GenericSampleSizeValue sampleSize = new GenericSampleSizeValue();
        for (ISampleSizeValue ss : sampleSizes) {
            sampleSize.setGroupASize(sampleSize.getGroupASize() + ss.getGroupASize());
            sampleSize.setGroupBSize(sampleSize.getGroupBSize() + ss.getGroupBSize());
            sampleSize.setNotSignedSize(sampleSize.getNotSignedSize() + ss.getNotSignedSize());
        }
        if (sampleSize.getGroupASize() > 0) {
            sampleSize.setGroupASize(sampleSize.getGroupASize() / sampleSizes.size());
        }
        if (sampleSize.getGroupBSize() > 0) {
            sampleSize.setGroupBSize(sampleSize.getGroupBSize() / sampleSizes.size());
        }
        if (sampleSize.getNotSignedSize() > 0) {
            sampleSize.setNotSignedSize(sampleSize.getNotSignedSize() / sampleSizes.size());
        }
        sampleSize.setSampleSize(sampleSize.getGroupASize() + sampleSize.getGroupBSize() + sampleSize.getNotSignedSize());
        sampleSize.setEstimateGroupA(sampleSize.getGroupASize());
        sampleSize.setEstimateGroupB(sampleSize.getGroupBSize());
        return sampleSize;
    }

    public static ISampleSizeValue meanPerComparisonsSampleSize(List<ISampleSizeValue> sampleSizes) {
        GenericSampleSizeValue sampleSize = new GenericSampleSizeValue();
        for (ISampleSizeValue ss : sampleSizes) {
            sampleSize.setGroupASize(sampleSize.getGroupASize() + ss.getGroupASize());
            sampleSize.setGroupBSize(sampleSize.getGroupBSize() + ss.getGroupBSize());
            sampleSize.setNotSignedSize(sampleSize.getNotSignedSize() + ss.getNotSignedSize());
        }
        if (sampleSize.getGroupBSize() > 0) {
            sampleSize.setGroupBSize(sampleSize.getGroupBSize() / sampleSizes.size());
        }
        if (sampleSize.getNotSignedSize() > 0) {
            sampleSize.setNotSignedSize(sampleSize.getNotSignedSize() / sampleSizes.size());
        }
        sampleSize.setSampleSize(sampleSize.getGroupASize() + sampleSize.getGroupBSize() + sampleSize.getNotSignedSize());
        sampleSize.setEstimateGroupA(sampleSize.getGroupASize());
        sampleSize.setEstimateGroupB(sampleSize.getGroupBSize());
        return sampleSize;
    }

    public void copyFrom(ISampleSizeValue obj) {
        this.groupASize = obj.getGroupASize();
        this.notSignedSize = obj.getNotSignedSize();
        this.sampleSize = obj.getSampleSize();
        this.groupBSize = obj.getGroupBSize();
    }

    public GenericSampleSizeValue duplicate() {
        return new GenericSampleSizeValue(this.sampleSize, this.groupASize, this.groupBSize, this.notSignedSize, this.estimateGroupA, this.estimateGroupB);
    }
}

