/*
 * Decompiled with CFR 0.152.
 */
package internovi.guifields.imp.basic;

import formattazione.numeri.MyNumberFormatter;
import internovi.guifields.api.AbstractRole;
import internovi.guifields.api.IGuiField;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public abstract class NumericalAbstractRole
extends AbstractRole {
    protected final MyNumberFormatter myNumberFormatter;

    public NumericalAbstractRole(JTextField source, MyNumberFormatter myNumberFormatter) {
        super(source);
        this.myNumberFormatter = myNumberFormatter;
    }

    public NumericalAbstractRole(JTextArea source, MyNumberFormatter myNumberFormatter) {
        super(source);
        this.myNumberFormatter = myNumberFormatter;
    }

    public NumericalAbstractRole(IGuiField iGuiField, MyNumberFormatter myNumberFormatter) {
        super(iGuiField);
        this.myNumberFormatter = myNumberFormatter;
    }

    public MyNumberFormatter getMyNumberFormatter() {
        return this.myNumberFormatter;
    }

    protected final Number parse(boolean integerOnly) {
        if (this.source.getText().equals("")) {
            return null;
        }
        ParsePosition pp = new ParsePosition(0);
        NumberFormat numberFormat = this.myNumberFormatter.getNumberFormat(15);
        numberFormat.setParseIntegerOnly(integerOnly);
        Number parse = numberFormat.parse(this.source.getText(), pp);
        if (parse != null) {
            return parse;
        }
        return null;
    }

    public final Double getDoubleValue() {
        Number parse = this.parse(false);
        if (parse == null) {
            return null;
        }
        return parse.doubleValue();
    }

    public final Integer getIntegerValue() {
        Number parse = this.parse(false);
        if (parse == null) {
            return null;
        }
        return parse.intValue();
    }

    public void setValue(double value) {
        this.source.setText(this.myNumberFormatter.formatInLang(value));
    }

    public void setValue(int value) {
        this.source.setText(this.myNumberFormatter.formatInLang(value));
    }
}

