/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.gui;

import effectsizeplot.gui.MyCellEditor;
import effectsizeplot.gui.MyDoubleCellEditor;
import formattazione.numeri.MyNumberFormatter;
import gui.alerts.GuiAlerts;
import java.awt.Component;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.openide.util.NbBundle;

public class MyIntegerCellEditor
extends MyCellEditor {
    public MyIntegerCellEditor(MyNumberFormatter myNumberFormatter) {
        super(myNumberFormatter);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.tf.getText().equals("")) {
            return null;
        }
        try {
            return this.getFormatter().getNumberFormat(0).parse(this.tf.getText()).intValue();
        }
        catch (Exception ex) {
            this.tf.setText("");
            GuiAlerts.whatAnError((String)NbBundle.getMessage(MyDoubleCellEditor.class, (String)"wrong.input.format"));
            return null;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jtable, Object o, boolean bln, int i, int i1) {
        JFormattedTextField editor = (JFormattedTextField)super.getTableCellEditorComponent(jtable, o, bln, i, i1);
        if (o instanceof Number) {
            editor.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(this.getFormatter().getNumberFormat(0))));
            editor.setHorizontalAlignment(4);
            editor.setValue(o);
        }
        return editor;
    }
}

