/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.wizards.opentopic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import metaanalysis.application.tools.TopicFileFilter;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.IDataFunctions;
import metaanalysis.core.functionsapi.events.TopicOpenedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.util.backup.BackupBean;
import metaanalysis.util.backup.BackupException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public final class ImportTopicFromFile
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
        Topic firstOpenedTopic = iApplicationManager.getIDataFunction().getFirstOpenedTopic();
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)new TopicFileFilter());
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                IDataFunctions f = (IDataFunctions)Lookup.getDefault().lookup(IDataFunctions.class);
                List allOpenedTopics = f.getAllOpenedTopics();
                if (allOpenedTopics.size() > 0 && NbPreferences.root().get("automaticBackup", "false").equals("true")) {
                    Topic t = (Topic)allOpenedTopics.get(0);
                    BackupBean backupBean = new BackupBean(t.getId(), f);
                    backupBean.fastBackup();
                }
            }
            catch (BackupException ex) {
                TuliTuliTools.whatAnError((String)ex.getMessage());
            }
            File file = fc.getSelectedFile();
            try {
                FileInputStream fis = new FileInputStream(file);
                BackupBean readFromFile = BackupBean.readFromFile((FileInputStream)fis);
                fis.close();
                Topic topic = iApplicationManager.getIDataFunction().getTopic(readFromFile.getTopic().getId());
                if (topic != null) {
                    int r = JOptionPane.showConfirmDialog(null, NbBundle.getMessage(ImportTopicFromFile.class, (String)"OpenTopic.override"), "Confirm", 0);
                    if (r == 0) {
                        readFromFile.getTopic().setName(topic.getName());
                        iApplicationManager.getIDataFunction().removeTopic(topic);
                    } else {
                        String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(ImportTopicFromFile.class, (String)"OpenTopic.newTopicName"), NbBundle.getMessage(ImportTopicFromFile.class, (String)"OpenTopic.insertNewTopicBarTitle"), 1);
                        if (nome == null || nome.equals("")) {
                            return;
                        }
                        readFromFile.getTopic().setName(nome);
                        readFromFile.getTopic().setId(new Date().getTime());
                    }
                } else {
                    String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(ImportTopicFromFile.class, (String)"OpenTopic.newTopicName"), NbBundle.getMessage(ImportTopicFromFile.class, (String)"OpenTopic.insertNewTopicBarTitle"), 1);
                    if (nome == null || nome.equals("")) {
                        return;
                    }
                    readFromFile.getTopic().setName(nome);
                }
                readFromFile.saveIntoDatabase(iApplicationManager.getIDataFunction());
                Topic newTopic = readFromFile.getTopic();
                iApplicationManager.getIDataFunction().openOneTopic(newTopic);
                iApplicationManager.setApplicationEvent((IApplicationEvent)new TopicOpenedEvent(newTopic, firstOpenedTopic));
                iApplicationManager.getMainUndoRedoManager().discardAllEdits();
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
                        List allOpenedTopics = iApplicationManager.getIDataFunction().getAllOpenedTopics();
                        if (!allOpenedTopics.isEmpty()) {
                            WindowManager.getDefault().getMainWindow().setTitle("ProMeta - " + ((Topic)allOpenedTopics.get(0)).getName());
                        } else {
                            WindowManager.getDefault().getMainWindow().setTitle("ProMeta");
                        }
                    }
                });
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

