/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.wizards.opentopic;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.IDataFunctions;
import metaanalysis.core.functionsapi.events.TopicOpenedEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.util.backup.BackupBean;
import metaanalysis.util.backup.BackupException;
import metaanalysis.wizards.opentopic.OpenTopicWizardWizardPanel1;
import metaanalysis.wizards.opentopic.OpenTopicWizardWizardPanel2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public final class OpenTopicWizardWizardAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
        ArrayList<Object> panels = new ArrayList<Object>();
        panels.add(new OpenTopicWizardWizardPanel1());
        panels.add(new OpenTopicWizardWizardPanel2());
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", true);
            jc.putClientProperty("WizardPanel_contentDisplayed", true);
            jc.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(NbBundle.getMessage(OpenTopicWizardWizardAction.class, (String)"wizard.panelTitle"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz) == WizardDescriptor.FINISH_OPTION) {
            int choice = (Integer)wiz.getProperty("choice");
            try {
                IDataFunctions f = (IDataFunctions)Lookup.getDefault().lookup(IDataFunctions.class);
                List allOpenedTopics = f.getAllOpenedTopics();
                if (allOpenedTopics.size() > 0 && NbPreferences.root().get("automaticBackup", "false").equals("true")) {
                    Topic t = (Topic)allOpenedTopics.get(0);
                    BackupBean backupBean = new BackupBean(t.getId(), f);
                    backupBean.fastBackup();
                }
            }
            catch (BackupException ex) {
                TuliTuliTools.whatAnError((String)ex.getMessage());
            }
            Topic firstOpenedTopic = iApplicationManager.getIDataFunction().getFirstOpenedTopic();
            if (choice == 0) {
                Topic newTopic = (Topic)wiz.getProperty("topic");
                iApplicationManager.getIDataFunction().openOneTopic(newTopic);
                iApplicationManager.setApplicationEvent((IApplicationEvent)new TopicOpenedEvent(newTopic, firstOpenedTopic));
                Frame f = WindowManager.getDefault().getMainWindow();
                f.setTitle("ProMeta - " + newTopic.getName());
            } else {
                String nome = (String)wiz.getProperty("topicName");
                String annotations = (String)wiz.getProperty("annotations");
                Topic t = new Topic();
                t.setName(nome);
                t.setNote(annotations);
                t.setTopictype(Integer.valueOf(choice));
                t.setStatus(Topic.closedTopic);
                iApplicationManager.getIDataFunction().createTopic(t);
                iApplicationManager.getIDataFunction().createPreanalysis(new Preanalysis(-1, "Pre-analysis", "", "", null, Long.valueOf(t.getId())));
                iApplicationManager.getIDataFunction().openOneTopic(t);
                Moderator newModerator = new Moderator();
                newModerator.setName(NbBundle.getMessage(OpenTopicWizardWizardAction.class, (String)"Moderator.pubyear.defaultName"));
                newModerator.setModeratortype(Integer.valueOf(Moderator.integerType));
                newModerator.setTopicId(Long.valueOf(t.getId()));
                newModerator.setSystemlevel(Moderator.publicationYearSystemLevel);
                iApplicationManager.getIDataFunction().createModerator(newModerator);
                newModerator = new Moderator();
                newModerator.setName(NbBundle.getMessage(OpenTopicWizardWizardAction.class, (String)"Moderator.pubType.defaultName"));
                newModerator.setModeratortype(Integer.valueOf(Moderator.categoricalType));
                newModerator.setDefvalues(NbBundle.getMessage(OpenTopicWizardWizardAction.class, (String)"Moderator.pubType.defaultValues"));
                newModerator.setTopicId(Long.valueOf(t.getId()));
                newModerator.setSystemlevel(Moderator.publicationTypeSystemLevel);
                iApplicationManager.getIDataFunction().createModerator(newModerator);
                iApplicationManager.setApplicationEvent((IApplicationEvent)new TopicOpenedEvent(t, firstOpenedTopic));
                Frame f = WindowManager.getDefault().getMainWindow();
                f.setTitle("ProMeta - " + t.getName());
            }
            iApplicationManager.getMainUndoRedoManager().discardAllEdits();
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
                List allOpenedTopics = iApplicationManager.getIDataFunction().getAllOpenedTopics();
                if (!allOpenedTopics.isEmpty()) {
                    WindowManager.getDefault().getMainWindow().setTitle("ProMeta - " + ((Topic)allOpenedTopics.get(0)).getName());
                } else {
                    WindowManager.getDefault().getMainWindow().setTitle("ProMeta");
                }
            }
        });
    }
}

